/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.server.jee.tx;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PostConstruct;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.jboss.capedwarf.jpa.EntityManagerProvider;
import org.jboss.capedwarf.jpa2.NewProxyingEntityManager;
import org.jboss.capedwarf.server.api.lifecycle.AfterImpl;
import org.jboss.capedwarf.server.api.lifecycle.Notification;
import org.jboss.capedwarf.server.api.persistence.EMFNotification;
import org.jboss.capedwarf.server.api.persistence.EMInjector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseEMInjector
implements EMInjector,
Serializable {
    private transient Event<Notification<EntityManagerFactory>> produceEvent;
    private static AtomicBoolean emitted = new AtomicBoolean(false);
    private transient EntityManager current;

    protected abstract EntityManager getInjectedEntityManager();

    protected abstract EntityManagerFactory getInjectedEntityManagerFactory();

    @PostConstruct
    public void init() {
        if (emitted.compareAndSet(false, true)) {
            this.produceEvent.select(new Annotation[]{new AfterImpl()}).fire((Object)new EMFNotification(this.getInjectedEntityManagerFactory()));
        }
    }

    public EntityManager getEM() {
        if (this.current == null) {
            this.current = new NewProxyingEntityManager(this.getInjectedEntityManager()){

                protected EntityManagerProvider getProvider() {
                    return new EntityManagerProvider(){

                        public EntityManager getEntityManager() {
                            return BaseEMInjector.this.getInjectedEntityManager();
                        }

                        public void close(EntityManager em) {
                        }
                    };
                }
            };
        }
        return this.current;
    }

    @Inject
    public void setProduceEvent(Event<Notification<EntityManagerFactory>> produceEvent) {
        this.produceEvent = produceEvent;
    }
}

