/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.server.jee.tx;

import java.io.Serializable;
import java.lang.reflect.AnnotatedElement;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.interceptor.InvocationContext;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.jboss.capedwarf.server.api.tx.TransactionPropagationType;
import org.jboss.capedwarf.server.api.tx.Transactional;
import org.jboss.capedwarf.server.api.tx.TxInterceptorDelegate;
import org.jboss.logging.Logger;

public class UserTransactionInterceptor
implements TxInterceptorDelegate,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(UserTransactionInterceptor.class);
    private transient UserTransaction tx;
    private transient Map<AnnotatedElement, TransactionMetadata> transactionMetadata = new HashMap<AnnotatedElement, TransactionMetadata>();

    public Object invoke(InvocationContext invocation) throws Exception {
        TransactionPropagationType propType = this.getPropType(invocation);
        switch (propType) {
            case MANDATORY: {
                return this.mandatory(invocation);
            }
            case NEVER: {
                return this.never(invocation);
            }
            case NOT_SUPPORTED: {
                return this.notSupported(invocation);
            }
            case REQUIRED: {
                return this.required(invocation);
            }
            case REQUIRES_NEW: {
                return this.requiresNew(invocation);
            }
            case SUPPORTS: {
                return this.supports(invocation);
            }
        }
        throw new IllegalStateException("Unexpected tx propagation type " + propType + " on " + invocation);
    }

    protected void endTransaction() {
        try {
            if (this.tx.getStatus() == 1) {
                this.tx.rollback();
            } else {
                this.tx.commit();
            }
        }
        catch (RollbackException e) {
            this.handleEndTransactionException((Exception)((Object)e));
        }
        catch (HeuristicMixedException e) {
            this.handleEndTransactionException((Exception)((Object)e));
        }
        catch (HeuristicRollbackException e) {
            this.handleEndTransactionException((Exception)((Object)e));
        }
        catch (SystemException e) {
            this.handleEndTransactionException((Exception)((Object)e));
        }
    }

    private TransactionPropagationType getPropType(InvocationContext invocation) {
        TransactionMetadata transMeta = this.lookupTransactionMetadata(invocation.getMethod());
        if (transMeta.isAnnotationPresent()) {
            return transMeta.getPropType();
        }
        transMeta = this.lookupTransactionMetadata(invocation.getTarget().getClass());
        if (transMeta.isAnnotationPresent()) {
            return transMeta.getPropType();
        }
        throw new RuntimeException("No Transacional annotation found. " + invocation);
    }

    protected Object invokeInCallerTx(InvocationContext invocation) throws Exception {
        try {
            return invocation.proceed();
        }
        catch (Throwable t) {
            this.handleExceptionInCallerTx(invocation, t);
            throw new RuntimeException("UNREACHABLE");
        }
    }

    protected Object invokeInNoTx(InvocationContext invocation) throws Exception {
        return invocation.proceed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object invokeInOurTx(InvocationContext invocation) throws Exception {
        this.tx.begin();
        try {
            Object object = invocation.proceed();
            return object;
        }
        catch (Throwable t) {
            this.handleExceptionInOurTx(invocation, t);
        }
        finally {
            this.endTransaction();
        }
        throw new RuntimeException("UNREACHABLE");
    }

    protected Object mandatory(InvocationContext invocation) throws Exception {
        if (this.tx.getStatus() != 0) {
            throw new RuntimeException("Transaction is required for invocation: " + invocation);
        }
        return this.invokeInCallerTx(invocation);
    }

    protected Object never(InvocationContext invocation) throws Exception {
        if (this.tx.getStatus() != 6) {
            throw new RuntimeException("Transaction present on server in Never call (EJB3 13.6.2.6)");
        }
        return this.invokeInNoTx(invocation);
    }

    protected Object notSupported(InvocationContext invocation) throws Exception {
        return this.invokeInNoTx(invocation);
    }

    protected Object required(InvocationContext invocation) throws Exception {
        if (this.tx.getStatus() == 6) {
            return this.invokeInOurTx(invocation);
        }
        return this.invokeInCallerTx(invocation);
    }

    protected Object requiresNew(InvocationContext invocation) throws Exception {
        if (this.tx.getStatus() == 0) {
            throw new NotSupportedException("Requires-New is not supported.");
        }
        return this.invokeInOurTx(invocation);
    }

    protected Object supports(InvocationContext invocation) throws Exception {
        if (this.tx.getStatus() == 6) {
            return this.invokeInNoTx(invocation);
        }
        return this.invokeInCallerTx(invocation);
    }

    protected void setRollbackOnly() {
        try {
            this.tx.setRollbackOnly();
        }
        catch (SystemException ex) {
            log.error((Object)"SystemException while setting transaction for rollback only", (Throwable)ex);
        }
        catch (IllegalStateException ex) {
            log.error((Object)"IllegalStateException while setting transaction for rollback only", (Throwable)ex);
        }
    }

    protected void handleEndTransactionException(Exception e) {
        throw new RuntimeException("Transaction rolled back", e);
    }

    protected void handleExceptionInCallerTx(InvocationContext invocation, Throwable t) throws Exception {
        this.setRollbackOnly();
        log.error((Object)t);
        throw (Exception)t;
    }

    public void handleExceptionInOurTx(InvocationContext invocation, Throwable t) throws Exception {
        this.setRollbackOnly();
        throw (Exception)t;
    }

    private TransactionMetadata lookupTransactionMetadata(AnnotatedElement element) {
        TransactionMetadata metadata = this.transactionMetadata.get(element);
        if (metadata == null) {
            metadata = this.loadMetadata(element);
        }
        return metadata;
    }

    private synchronized TransactionMetadata loadMetadata(AnnotatedElement element) {
        if (!this.transactionMetadata.containsKey(element)) {
            TransactionMetadata metadata = new TransactionMetadata(element);
            this.transactionMetadata.put(element, metadata);
            return metadata;
        }
        return this.transactionMetadata.get(element);
    }

    @Inject
    public void setUserTransaction(UserTransaction tx) {
        this.tx = tx;
    }

    private class TransactionMetadata {
        private boolean annotationPresent;
        private TransactionPropagationType propType;

        public TransactionMetadata(AnnotatedElement element) {
            this.annotationPresent = element.isAnnotationPresent(Transactional.class);
            if (this.annotationPresent) {
                this.propType = element.getAnnotation(Transactional.class).value();
            }
        }

        public boolean isAnnotationPresent() {
            return this.annotationPresent;
        }

        public TransactionPropagationType getPropType() {
            return this.propType;
        }
    }
}

