/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.server.jee.users;

import java.security.Principal;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.servlet.http.HttpServletRequest;
import org.jboss.capedwarf.server.api.quilifiers.Current;
import org.jboss.capedwarf.server.api.users.User;
import org.jboss.capedwarf.server.api.users.UserHandler;

@ApplicationScoped
public class Users
implements UserHandler {
    @Produces
    @Current
    public User currentUser(HttpServletRequest req) {
        Principal principal = req.getUserPrincipal();
        return principal != null ? new UserImpl(principal) : null;
    }

    public String loginURL(String requestURI) {
        return "restricted/login.cdi";
    }

    public String logoutURL(String requestURI) {
        return "restricted/logout.cdi";
    }

    private static class UserImpl
    implements User {
        private Principal principal;

        private UserImpl(Principal principal) {
            this.principal = principal;
        }

        public String getEmail() {
            return this.principal.getName();
        }

        public String toString() {
            return this.getEmail();
        }
    }
}

