/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.server.jee.io;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.UUID;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Alternative;
import org.jboss.capedwarf.server.api.io.AbstractSimpleBlobService;

@ApplicationScoped
@Alternative
public class DefaultBlobService
extends AbstractSimpleBlobService {
    private volatile File dataDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File getDataDir() {
        if (this.dataDir == null) {
            DefaultBlobService defaultBlobService = this;
            synchronized (defaultBlobService) {
                if (this.dataDir == null) {
                    String dataDirProp = System.getProperty("jboss.server.data.dir", System.getProperty("user.home"));
                    File tmp = new File(dataDirProp, "capedwarf");
                    tmp.mkdirs();
                    this.dataDir = tmp;
                }
            }
        }
        return this.dataDir;
    }

    protected byte[] loadBytesInternal(String key, long startIndex, long endIndex) {
        File file = new File(this.getDataDir(), key);
        if (!file.exists()) {
            return null;
        }
        FileInputStream fis = null;
        try {
            int b;
            fis = new FileInputStream(file);
            if (startIndex > 0L) {
                startIndex = fis.skip(startIndex);
            }
            endIndex -= startIndex;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while (endIndex > 0L && (b = fis.read()) != -1) {
                baos.write(b);
                --endIndex;
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String storeBytesInternal(String mimeType, ByteBuffer buffer) throws IOException {
        String key = UUID.randomUUID().toString();
        File file = new File(this.getDataDir(), key);
        FileOutputStream fos = new FileOutputStream(file);
        try {
            while (buffer.hasRemaining()) {
                fos.write(buffer.get());
            }
            fos.flush();
        }
        finally {
            fos.close();
        }
        return key;
    }
}

