/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.server.jee.mail;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.jboss.capedwarf.server.api.mail.impl.AbstractMailManager;
import org.jboss.capedwarf.server.jee.env.Environment;

@ApplicationScoped
public class BasicMailManager
extends AbstractMailManager {
    private Session session;

    public void sendEmail(String sender, String subject, String textBody, String ... tos) {
        if (this.session == null) {
            return;
        }
        try {
            Address[] addresses = new Address[tos.length];
            for (int i = 0; i < tos.length; ++i) {
                addresses[i] = new InternetAddress(tos[i]);
            }
            MimeMessage msg = new MimeMessage(this.session);
            msg.setFrom((Address)new InternetAddress(sender));
            msg.addRecipients(Message.RecipientType.TO, addresses);
            msg.setSubject(subject);
            msg.setText(textBody);
            Transport.send((Message)msg);
        }
        catch (Exception e) {
            this.log.warning("Failed to send email: " + e);
        }
    }

    public void sendEmailToAdmins(String sender, String subject, String textBody) {
        this.sendEmail(sender, subject, textBody, this.adminManager.getAppAdminEmail());
    }

    @Inject
    public void setEnv(Environment env) throws Exception {
        this.session = env.lookupMailSession();
        if (this.session == null) {
            this.log.warning("No mail session setup.");
        }
    }
}

