/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.validation.api;

import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.validation.ConstraintViolationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ValidationListener {
    private static Logger log = Logger.getLogger(ValidationListener.class.getName());
    private static boolean warning;
    private static ValidatorFactory factory;

    public void validate(Object object) throws Exception {
        if (factory == null) {
            if (!warning) {
                log.warning("No ValidatorFactory set!");
                warning = true;
            }
            return;
        }
        Validator validator = factory.getValidator();
        Set violations = validator.validate(object, new Class[0]);
        if (!violations.isEmpty()) {
            log.log(Level.INFO, "Constraint violations: " + violations.toString());
            throw new ConstraintViolationException("Invalid object: " + object, violations);
        }
    }

    public static void setFactory(ValidatorFactory vf) {
        if (vf == null) {
            throw new IllegalArgumentException("Null factory");
        }
        factory = vf;
    }
}

