/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.validation;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.TraversableResolver;
import javax.validation.Validator;
import javax.validation.ValidatorContext;
import javax.validation.ValidatorFactory;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.jboss.capedwarf.validation.SimpleBeanDescriptor;
import org.jboss.capedwarf.validation.SimpleSizeConstraintValidator;
import org.jboss.capedwarf.validation.SimpleValidator;
import org.jboss.capedwarf.validation.SimpleValidatorContext;
import org.jboss.capedwarf.validation.ValidatorHolder;
import org.jboss.capedwarf.validation.api.Email;
import org.jboss.capedwarf.validation.api.EmailConstraintValidator;
import org.jboss.capedwarf.validation.api.NotNullConstraintValidator;
import org.jboss.capedwarf.validation.api.PatternConstraintValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleValidatorFactory
extends ValidatorHolder<SimpleValidatorFactory>
implements ValidatorFactory {
    private Map<Class<? extends Annotation>, Class<? extends ConstraintValidator<? extends Annotation, Object>>> constraints = new WeakHashMap<Class<? extends Annotation>, Class<? extends ConstraintValidator<? extends Annotation, Object>>>();
    private Map<Class<?>, SimpleBeanDescriptor> descriptors = new ConcurrentHashMap();

    public SimpleValidatorFactory() {
        this.init();
    }

    public SimpleValidatorFactory(MessageInterpolator messageInterpolator, TraversableResolver traversableResolver, ConstraintValidatorFactory constraintValidatorFactory) {
        super(messageInterpolator, traversableResolver, constraintValidatorFactory);
        this.init();
    }

    private void init() {
        this.put(NotNull.class, NotNullConstraintValidator.class);
        this.put(Size.class, SimpleSizeConstraintValidator.class);
        this.put(Email.class, EmailConstraintValidator.class);
        this.put(Pattern.class, PatternConstraintValidator.class);
    }

    List<Class<? extends ConstraintValidator>> getConstraintValidatorClasses() {
        return new ArrayList<Class<? extends ConstraintValidator>>(this.constraints.values());
    }

    public Validator getValidator() {
        return new SimpleValidator(this);
    }

    Set<Class<? extends Annotation>> getConstraintKeys() {
        return this.constraints.keySet();
    }

    ConstraintValidator<? extends Annotation, Object> getConstraintValidator(Class<? extends Annotation> ac) {
        if (ac == null) {
            throw new IllegalArgumentException("Null annotation");
        }
        Class<? extends ConstraintValidator<? extends Annotation, Object>> validatorClass = this.get(ac);
        if (validatorClass == null) {
            return null;
        }
        try {
            return validatorClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Class<? extends ConstraintValidator<? extends Annotation, Object>> get(Class<? extends Annotation> clazz) {
        return this.constraints.get(clazz);
    }

    public void put(Class<? extends Annotation> clazz, Class<? extends ConstraintValidator<? extends Annotation, Object>> cv) {
        this.constraints.put(clazz, cv);
    }

    public void remove(Class<? extends Annotation> clazz) {
        this.constraints.remove(clazz);
    }

    SimpleBeanDescriptor getBeanDescriptor(Class<?> beanClass) {
        SimpleBeanDescriptor bc = this.descriptors.get(beanClass);
        if (bc == null) {
            bc = new SimpleBeanDescriptor(this, beanClass);
            this.descriptors.put(beanClass, bc);
        }
        return bc;
    }

    public ValidatorContext usingContext() {
        return new SimpleValidatorContext(this);
    }

    public <T> T unwrap(Class<T> type) {
        return null;
    }
}

