/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.validation;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintValidator;
import javax.validation.Payload;
import javax.validation.ValidationException;
import javax.validation.metadata.ConstraintDescriptor;
import org.jboss.capedwarf.validation.SimpleValidatorFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SimpleConstraintDescriptor<T extends Annotation>
implements ConstraintDescriptor<T> {
    private SimpleValidatorFactory factory;
    private T annotation;
    private Map<String, Object> attributes;

    SimpleConstraintDescriptor(SimpleValidatorFactory factory, T annotation) {
        if (factory == null) {
            throw new IllegalArgumentException("Null factory");
        }
        if (annotation == null) {
            throw new IllegalArgumentException("Null annotation");
        }
        this.annotation = annotation;
        this.attributes = this.buildAnnotationParameterMap();
    }

    public T getAnnotation() {
        return this.annotation;
    }

    public Set<Class<?>> getGroups() {
        return Collections.emptySet();
    }

    public Set<Class<? extends Payload>> getPayload() {
        return Collections.emptySet();
    }

    public List<Class<? extends ConstraintValidator<T, ?>>> getConstraintValidatorClasses() {
        return new ArrayList(this.factory.getConstraintValidatorClasses());
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public Set<ConstraintDescriptor<?>> getComposingConstraints() {
        return Collections.emptySet();
    }

    public boolean isReportAsSingleViolation() {
        return false;
    }

    private Map<String, Object> buildAnnotationParameterMap() {
        Method[] declaredMethods = System.getSecurityManager() != null ? AccessController.doPrivileged(new PrivilegedAction<Method[]>(){

            @Override
            public Method[] run() {
                return SimpleConstraintDescriptor.this.annotation.annotationType().getDeclaredMethods();
            }
        }) : this.annotation.annotationType().getDeclaredMethods();
        HashMap<String, Object> parameters = new HashMap<String, Object>(declaredMethods.length);
        for (Method m : declaredMethods) {
            try {
                parameters.put(m.getName(), m.invoke(this.annotation, new Object[0]));
            }
            catch (IllegalAccessException e) {
                throw new ValidationException("Unable to read annotation attributes: " + this.annotation.getClass(), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new ValidationException("Unable to read annotation attributes: " + this.annotation.getClass(), (Throwable)e);
            }
        }
        return Collections.unmodifiableMap(parameters);
    }
}

