/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.validation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.ConstraintDescriptor;
import javax.validation.metadata.ElementDescriptor;
import javax.validation.metadata.PropertyDescriptor;
import org.jboss.capedwarf.validation.SimplePropertyDescriptor;
import org.jboss.capedwarf.validation.SimpleValidatorFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SimpleBeanDescriptor
implements BeanDescriptor {
    private SimpleValidatorFactory factory;
    private Class<?> beanClass;
    private Map<String, SimplePropertyDescriptor> properties;

    SimpleBeanDescriptor(SimpleValidatorFactory factory, Class<?> beanClass) {
        if (beanClass == null) {
            throw new IllegalArgumentException("Null bean class");
        }
        this.factory = factory;
        this.beanClass = beanClass;
        this.properties = new HashMap<String, SimplePropertyDescriptor>();
        this.init();
    }

    protected void init() {
        Method[] ms;
        for (Method m : ms = this.beanClass.getMethods()) {
            Annotation[] da;
            String methodName = m.getName();
            if (!this.isPropertyGetter(m)) continue;
            for (Annotation a : da = m.getDeclaredAnnotations()) {
                Class<? extends Annotation> ac = a.annotationType();
                if (this.factory.get(ac) == null) continue;
                SimplePropertyDescriptor pd = this.properties.get(methodName);
                if (pd == null) {
                    pd = new SimplePropertyDescriptor(methodName, m.getReturnType());
                    this.properties.put(methodName, pd);
                }
                pd.addConstraintAnnotation(ac);
            }
        }
    }

    protected boolean isPropertyGetter(Method m) {
        String name = m.getName();
        if (name.startsWith("get") || name.startsWith("is")) {
            Class<?>[] paramTypes = m.getParameterTypes();
            return paramTypes.length == 0;
        }
        return false;
    }

    public boolean isBeanConstrained() {
        return this.hasConstraints();
    }

    public SimplePropertyDescriptor getConstraintsForProperty(String propertyName) {
        return this.properties.get(propertyName);
    }

    public Set<PropertyDescriptor> getConstrainedProperties() {
        return new HashSet<PropertyDescriptor>(this.properties.values());
    }

    Set<SimplePropertyDescriptor> getConstrainedSimpleProperties() {
        return new HashSet<SimplePropertyDescriptor>(this.properties.values());
    }

    public boolean hasConstraints() {
        return !this.properties.isEmpty();
    }

    public Class<?> getElementClass() {
        return this.beanClass;
    }

    public Set<ConstraintDescriptor<?>> getConstraintDescriptors() {
        return Collections.emptySet();
    }

    public ElementDescriptor.ConstraintFinder findConstraints() {
        return null;
    }
}

