/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.capedwarf.validation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.validation.metadata.ConstraintDescriptor;
import javax.validation.metadata.ElementDescriptor;
import javax.validation.metadata.PropertyDescriptor;
import org.jboss.capedwarf.validation.api.MessageTemplateKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SimplePropertyDescriptor
implements PropertyDescriptor {
    private String propertyName;
    private Class<?> propertyType;
    private Set<Class<? extends Annotation>> constraintAnnotations = new HashSet<Class<? extends Annotation>>();

    SimplePropertyDescriptor(String propertyName, Class<?> propertyType) {
        this.propertyName = propertyName;
        this.propertyType = propertyType;
    }

    void addConstraintAnnotation(Class<? extends Annotation> ac) {
        this.constraintAnnotations.add(ac);
    }

    Set<Class<? extends Annotation>> getConstraintAnnotations() {
        return this.constraintAnnotations;
    }

    Annotation getAnnotation(Class<?> clazz, Class<? extends Annotation> ac) {
        try {
            Method m = clazz.getMethod(this.propertyName, new Class[0]);
            return m.getAnnotation(ac);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    Object getValue(Object object) {
        try {
            Class<?> clazz = object.getClass();
            Method m = clazz.getMethod(this.propertyName, new Class[0]);
            return m.invoke(object, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    String getMessageTemplateKey(Class<?> beanClass) {
        try {
            Method m = beanClass.getMethod(this.propertyName, new Class[0]);
            MessageTemplateKey mtk = m.getAnnotation(MessageTemplateKey.class);
            if (mtk != null) {
                return mtk.value();
            }
            mtk = beanClass.getAnnotation(MessageTemplateKey.class);
            return mtk != null ? mtk.value() : null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isCascaded() {
        return false;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public boolean hasConstraints() {
        return !this.constraintAnnotations.isEmpty();
    }

    public Class<?> getElementClass() {
        return this.propertyType;
    }

    public Set<ConstraintDescriptor<?>> getConstraintDescriptors() {
        return Collections.emptySet();
    }

    public ElementDescriptor.ConstraintFinder findConstraints() {
        return null;
    }
}

