/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.shrinkwrap;

import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.enterprise.inject.spi.Extension;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.ShouldThrowException;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.api.Configuration;
import org.jboss.cdi.tck.impl.ConfigurationFactory;
import org.jboss.cdi.tck.impl.ConfigurationImpl;
import org.jboss.cdi.tck.impl.MockCreationalContext;
import org.jboss.cdi.tck.impl.OldSPIBridge;
import org.jboss.cdi.tck.impl.PropertiesBasedConfigurationBuilder;
import org.jboss.cdi.tck.literals.AnyLiteral;
import org.jboss.cdi.tck.spi.Beans;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.container.ClassContainer;
import org.jboss.shrinkwrap.api.container.LibraryContainer;
import org.jboss.shrinkwrap.api.container.ManifestContainer;
import org.jboss.shrinkwrap.api.container.ResourceContainer;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.beans10.BeansDescriptor;
import org.jboss.shrinkwrap.descriptor.api.persistence20.PersistenceDescriptor;
import org.jboss.shrinkwrap.descriptor.api.webapp30.WebAppDescriptor;
import org.jboss.shrinkwrap.impl.base.URLPackageScanner;

public abstract class ArchiveBuilder<T extends ArchiveBuilder<T, A>, A extends Archive<A>> {
    private String name;
    private boolean isAsClientMode = false;
    private boolean isTestArchive = true;
    private Class<?> testClazz = null;
    protected ResourceDescriptor beansXml = null;
    protected BeansDescriptor beansDescriptor = null;
    protected ResourceDescriptor webXml = null;
    protected WebAppDescriptor webXmlDescriptor = null;
    protected PersistenceDescriptor persistenceDescriptor = null;
    protected List<ResourceDescriptor> manifestResources = null;
    protected List<ResourceDescriptor> resources = null;
    protected List<ResourceDescriptor> webResources = null;
    protected List<String> packages = null;
    protected List<String> classes = null;
    protected List<String> excludedClasses = null;
    protected List<LibraryDescriptor> libraries = null;
    protected List<ServiceProviderDescriptor> serviceProviders = null;

    public T withName(String name) {
        this.name = name;
        return this.self();
    }

    public T withBeansXml(String beansXml) {
        this.beansXml = new ResourceDescriptor(beansXml, "beans.xml");
        return this.self();
    }

    public T withBeansXml(BeansDescriptor beansDescriptor) {
        this.beansDescriptor = beansDescriptor;
        return this.self();
    }

    public T withExtension(String extension) {
        return this.withManifestResource(extension, "services/javax.enterprise.inject.spi.Extension", true);
    }

    public T withExtension(Class<? extends Extension> extensionClass) {
        return this.withServiceProvider(new ServiceProviderDescriptor(Extension.class, extensionClass));
    }

    public T withExtensions(Class<? extends Extension> ... extensionClasses) {
        return this.withServiceProvider(new ServiceProviderDescriptor(Extension.class, extensionClasses));
    }

    public T withServiceProvider(ServiceProviderDescriptor serviceProvider) {
        if (this.serviceProviders == null) {
            this.serviceProviders = new ArrayList<ServiceProviderDescriptor>();
        }
        this.serviceProviders.add(serviceProvider);
        return this.self();
    }

    public T withClass(Class<?> clazz) {
        if (this.classes == null) {
            this.classes = new ArrayList<String>();
        }
        this.classes.add(clazz.getName());
        return this.self();
    }

    public T withClasses(Class<?> ... classes) {
        for (Class<?> clazz : classes) {
            this.withClass(clazz);
        }
        return this.self();
    }

    public T withExcludedClass(String clazz) {
        if (this.excludedClasses == null) {
            this.excludedClasses = new ArrayList<String>();
        }
        this.excludedClasses.add(clazz);
        return this.self();
    }

    public T withExcludedClasses(String ... classes) {
        for (String clazz : classes) {
            this.withExcludedClass(clazz);
        }
        return this.self();
    }

    public T withTestClassPackage(Class<?> testClazz) {
        return super.withPackage(testClazz.getPackage());
    }

    public T withTestClass(Class<?> testClazz) {
        return ((ArchiveBuilder)this.withTestClassDefinition(testClazz)).withClass(testClazz);
    }

    public T withTestClassDefinition(Class<?> testClazz) {
        if (this.testClazz != null) {
            throw new IllegalStateException("Cannot set more than one test class definition!");
        }
        this.testClazz = testClazz;
        return this.self();
    }

    private T withPackage(Package pack) {
        if (this.packages == null) {
            this.packages = new ArrayList<String>();
        }
        this.packages.add(pack.getName());
        return this.self();
    }

    public T withManifestResource(String source) {
        return this.withManifestResource(source, null, true);
    }

    public T withManifestResource(String source, boolean useTestPackageToLocateSource) {
        return this.withManifestResource(source, null, useTestPackageToLocateSource);
    }

    public T withManifestResource(String source, String target, boolean useTestPackageToLocateSource) {
        if (this.manifestResources == null) {
            this.manifestResources = new ArrayList<ResourceDescriptor>();
        }
        this.manifestResources.add(new ResourceDescriptor(source, target, useTestPackageToLocateSource));
        return this.self();
    }

    public T withResource(String source) {
        return this.withResource(source, null, true);
    }

    public T withResource(String source, boolean useTestPackageToLocateSource) {
        return this.withResource(source, null, useTestPackageToLocateSource);
    }

    public T withResource(String source, String target, boolean useTestPackageToLocateSource) {
        if (this.resources == null) {
            this.resources = new ArrayList<ResourceDescriptor>();
        }
        this.resources.add(new ResourceDescriptor(source, target, useTestPackageToLocateSource));
        return this.self();
    }

    public T withWebResource(String source) {
        return this.withWebResource(source, null, true);
    }

    public T withWebResource(String source, String target) {
        return this.withWebResource(source, target, true);
    }

    public T withWebResource(String source, boolean useTestPackageToLocateSource) {
        return this.withWebResource(source, null, useTestPackageToLocateSource);
    }

    public T withWebResource(String source, String target, boolean useTestPackageToLocateSource) {
        if (this.webResources == null) {
            this.webResources = new ArrayList<ResourceDescriptor>();
        }
        this.webResources.add(new ResourceDescriptor(source, target, useTestPackageToLocateSource));
        return this.self();
    }

    public T withEjbJarXml(String ejbJarXml) {
        return this.withManifestResource(ejbJarXml, "ejb-jar.xml", true);
    }

    public T withWebXml(String webXml) {
        this.webXml = new ResourceDescriptor(webXml);
        return this.self();
    }

    public T withWebXml(WebAppDescriptor webXml) {
        this.webXmlDescriptor = webXml;
        return this.self();
    }

    public T withDefaultPersistenceXml() {
        return this.withPersistenceXml((PersistenceDescriptor)((PersistenceDescriptor)Descriptors.create(PersistenceDescriptor.class)).createPersistenceUnit().name("test").jtaDataSource(ConfigurationFactory.get().getTestDataSource()).up());
    }

    public T withPersistenceXml(PersistenceDescriptor persistenceDescriptor) {
        this.persistenceDescriptor = persistenceDescriptor;
        return this.self();
    }

    public T withLibrary(File library) {
        if (this.libraries == null) {
            this.libraries = new ArrayList<LibraryDescriptor>();
        }
        this.libraries.add(new LibraryDescriptor(library));
        return this.self();
    }

    public T withBeanLibrary(Class<?> ... beanClasses) {
        return this.withLibrary(null, true, beanClasses);
    }

    public T withBeanLibrary(BeansDescriptor beansDescriptor, Class<?> ... beanClasses) {
        return this.withBeanLibrary(null, beansDescriptor, beanClasses);
    }

    public T withBeanLibrary(String name, Class<?> ... beanClasses) {
        return this.withBeanLibrary(name, (BeansDescriptor)null, beanClasses);
    }

    public T withBeanLibrary(String name, BeansDescriptor beansDescriptor, Class<?> ... beanClasses) {
        return this.withLibrary(name, beansDescriptor, true, beanClasses);
    }

    public T withLibrary(Class<?> ... classes) {
        return this.withLibrary(null, false, classes);
    }

    public T withLibrary(BeansDescriptor beansDescriptor, boolean includeEmptyBeanXml, Class<?> ... classes) {
        return this.withLibrary(null, beansDescriptor, includeEmptyBeanXml, classes);
    }

    public T withLibrary(String name, BeansDescriptor beansDescriptor, boolean includeEmptyBeanXml, Class<?> ... classes) {
        if (this.libraries == null) {
            this.libraries = new ArrayList<LibraryDescriptor>();
        }
        ArrayList extensions = new ArrayList();
        for (Class<?> clazz : classes) {
            if (!Extension.class.isAssignableFrom(clazz)) continue;
            extensions.add(clazz);
        }
        ServiceProviderDescriptor serviceProvider = extensions.isEmpty() ? null : new ServiceProviderDescriptor(Extension.class, extensions.toArray(new Class[extensions.size()]));
        this.libraries.add(beansDescriptor != null ? new LibraryDescriptor(name, serviceProvider, beansDescriptor, classes) : new LibraryDescriptor(name, serviceProvider, includeEmptyBeanXml, classes));
        return this.self();
    }

    public abstract T self();

    public A build() {
        if (this.isTestArchive()) {
            if (this.testClazz == null) {
                throw new IllegalStateException("Test class must be set!");
            }
            this.resolveAsClientMode();
            this.withResource("META-INF/cdi-tck.properties", null, false);
            this.withPackage(Configuration.class.getPackage());
            this.withPackage(Beans.class.getPackage());
            this.withClasses(ConfigurationFactory.class, ConfigurationImpl.class, PropertiesBasedConfigurationBuilder.class, MockCreationalContext.class, OldSPIBridge.class);
            this.withPackage(AnyLiteral.class.getPackage());
            this.addDefaultLibraries();
            if (!this.isAsClientMode()) {
                this.withClass(AbstractTest.class);
            }
        }
        return this.buildInternal();
    }

    protected abstract A buildInternal();

    protected void processPackages(final ClassContainer<?> archive) {
        if (this.packages == null) {
            return;
        }
        for (String pack : this.packages) {
            URLPackageScanner.Callback callback = new URLPackageScanner.Callback(){

                public void classFound(String className) {
                    if (ArchiveBuilder.this.isAsClientMode() && ArchiveBuilder.this.testClazz.getName().equals(className) || ArchiveBuilder.this.excludedClasses != null && ArchiveBuilder.this.excludedClasses.contains(className)) {
                        return;
                    }
                    archive.addClass(className);
                }
            };
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                classLoader = this.getClass().getClassLoader();
            }
            URLPackageScanner scanner = URLPackageScanner.newInstance((boolean)false, (ClassLoader)classLoader, (URLPackageScanner.Callback)callback, (String)pack);
            scanner.scanPackage();
        }
    }

    protected void processClasses(ClassContainer<?> archive) {
        if (this.classes == null) {
            return;
        }
        for (String clazz : this.classes) {
            if (this.isAsClientMode() && this.testClazz.getName().equals(clazz) || this.excludedClasses != null && this.excludedClasses.contains(clazz)) continue;
            archive.addClass(clazz);
        }
    }

    protected void processLibraries(LibraryContainer<?> archive) {
        if (this.libraries != null) {
            for (LibraryDescriptor descriptor : this.libraries) {
                if (descriptor.getFileDescriptor() != null) {
                    archive.addAsLibrary(descriptor.getFileDescriptor());
                    continue;
                }
                archive.addAsLibrary((Archive)descriptor.buildJarArchive());
            }
        }
    }

    protected void processResources(ResourceContainer<?> archive) {
        if (this.resources == null) {
            return;
        }
        for (ResourceDescriptor resource : this.resources) {
            if (resource.getTarget() == null) {
                archive.addAsResource(resource.getSource());
                continue;
            }
            archive.addAsResource(resource.getSource(), resource.getTarget());
        }
    }

    protected void processManifestResources(ManifestContainer<?> archive) {
        if (this.manifestResources != null) {
            for (ResourceDescriptor resource : this.manifestResources) {
                if (resource.getTarget() == null) {
                    archive.addAsManifestResource(resource.getSource());
                    continue;
                }
                archive.addAsManifestResource(resource.getSource(), resource.getTarget());
            }
        }
        if (this.serviceProviders != null) {
            for (ServiceProviderDescriptor descriptor : this.serviceProviders) {
                archive.addAsServiceProvider(descriptor.getServiceInterface(), (Class[])descriptor.getServiceImplementations());
            }
        }
    }

    private void addDefaultLibraries() {
        File directory = new File(ConfigurationFactory.get(true).getLibraryDirectory());
        if (directory.isDirectory()) {
            for (File file : directory.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".jar");
                }
            })) {
                this.withLibrary(file);
            }
        }
    }

    private String getTestPackagePath() {
        return this.testClazz.getPackage().getName().replace('.', '/').concat("/");
    }

    protected boolean isAsClientMode() {
        return this.isAsClientMode;
    }

    public boolean isTestArchive() {
        return this.isTestArchive;
    }

    public T notTestArchive() {
        this.isTestArchive = false;
        return this.self();
    }

    private void resolveAsClientMode() {
        for (Method method : this.testClazz.getMethods()) {
            if (!method.isAnnotationPresent(Deployment.class)) continue;
            if (method.isAnnotationPresent(ShouldThrowException.class)) {
                this.isAsClientMode = true;
                break;
            }
            if (method.getAnnotation(Deployment.class).testable()) break;
            this.isAsClientMode = true;
            break;
        }
    }

    public String getName() {
        return this.name;
    }

    protected class LibraryDescriptor {
        private String name;
        private File fileDescriptor = null;
        private List<Class<?>> libraryClasses = null;
        protected BeansDescriptor beansDescriptor = null;
        private boolean includeEmptyBeanXml = false;
        private List<ServiceProviderDescriptor> serviceProviders;

        public LibraryDescriptor(File fileDescriptor) {
            this.fileDescriptor = fileDescriptor;
        }

        public LibraryDescriptor(String name, ServiceProviderDescriptor serviceProvider, BeansDescriptor beansDescriptor, Class<?> ... classes) {
            if (serviceProvider != null) {
                this.serviceProviders = new ArrayList<ServiceProviderDescriptor>();
                this.serviceProviders.add(serviceProvider);
            }
            this.beansDescriptor = beansDescriptor;
            this.libraryClasses = Arrays.asList(classes);
            this.name = name;
        }

        public LibraryDescriptor(String name, ServiceProviderDescriptor serviceProvider, boolean includeEmptyBeanXml, Class<?> ... classes) {
            if (serviceProvider != null) {
                this.serviceProviders = new ArrayList<ServiceProviderDescriptor>();
                this.serviceProviders.add(serviceProvider);
            }
            this.includeEmptyBeanXml = includeEmptyBeanXml;
            this.libraryClasses = Arrays.asList(classes);
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public List<Class<?>> getBeanClasses() {
            return this.libraryClasses;
        }

        public ResourceDescriptor getBeansXml() {
            return ArchiveBuilder.this.beansXml;
        }

        public boolean isOmitBeanXml() {
            return this.includeEmptyBeanXml;
        }

        public File getFileDescriptor() {
            return this.fileDescriptor;
        }

        public List<ServiceProviderDescriptor> getServiceProviders() {
            return this.serviceProviders;
        }

        public JavaArchive buildJarArchive() {
            JavaArchive library = null;
            library = this.name != null ? (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)this.name) : (JavaArchive)ShrinkWrap.create(JavaArchive.class);
            for (Class<?> clazz : this.libraryClasses) {
                library.addClass(clazz);
            }
            if (this.serviceProviders != null) {
                for (ServiceProviderDescriptor serviceProvider : this.serviceProviders) {
                    library.addAsServiceProvider(serviceProvider.getServiceInterface(), (Class[])serviceProvider.getServiceImplementations());
                }
            }
            if (this.beansDescriptor != null) {
                library.addAsManifestResource((Asset)new StringAsset(this.beansDescriptor.exportAsString()), this.beansDescriptor.getDescriptorName());
            } else if (this.includeEmptyBeanXml) {
                library.addAsManifestResource((Asset)EmptyAsset.INSTANCE, ArchivePaths.create((String)"beans.xml"));
            }
            return library;
        }
    }

    protected class ResourceDescriptor {
        private String source;
        private String target;
        private boolean useTestPackageToLocateSource = true;

        public ResourceDescriptor(String source) {
            this.source = source;
        }

        public ResourceDescriptor(String source, String target) {
            this.source = source;
            this.target = target;
        }

        public ResourceDescriptor(String source, String target, boolean useTestPackageToLocateSource) {
            this.source = source;
            this.target = target;
            this.useTestPackageToLocateSource = useTestPackageToLocateSource;
        }

        public String getSource() {
            return this.useTestPackageToLocateSource ? ArchiveBuilder.this.getTestPackagePath() + this.source : this.source;
        }

        public String getPlainSource() {
            return this.source;
        }

        public String getTarget() {
            return this.target;
        }
    }

    protected class ServiceProviderDescriptor {
        private Class<?> serviceInterface;
        private Class<?>[] serviceImplementations;

        public ServiceProviderDescriptor(Class<?> serviceInterface, Class<?> ... serviceImplementations) {
            this.serviceInterface = serviceInterface;
            this.serviceImplementations = serviceImplementations;
        }

        public Class<?> getServiceInterface() {
            return this.serviceInterface;
        }

        public Class<?>[] getServiceImplementations() {
            return this.serviceImplementations;
        }
    }
}

