/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.alternative;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.util.AnnotationLiteral;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.alternative.Animal;
import org.jboss.cdi.tck.tests.alternative.Bird;
import org.jboss.cdi.tck.tests.alternative.Cat;
import org.jboss.cdi.tck.tests.alternative.Chicken;
import org.jboss.cdi.tck.tests.alternative.Dog;
import org.jboss.cdi.tck.tests.alternative.Horse;
import org.jboss.cdi.tck.tests.alternative.Sheep;
import org.jboss.cdi.tck.tests.alternative.Tame;
import org.jboss.cdi.tck.tests.alternative.Wild;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class AlternativeAvailabilityTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(AlternativeAvailabilityTest.class)).withBeansXml("beans.xml")).build();
    }

    @Test(groups={"alternatives"})
    @SpecAssertions(value={@SpecAssertion(section="5.1", id="e"), @SpecAssertion(section="5.1.1", id="c"), @SpecAssertion(section="5.1.1", id="ea"), @SpecAssertion(section="2.6", id="a"), @SpecAssertion(section="2.6.1", id="a"), @SpecAssertion(section="12.4", id="ka")})
    public void testAlternativeAvailability() throws Exception {
        Set<Bean<Animal>> animals = this.getBeans(Animal.class, new Annotation[0]);
        HashSet types = new HashSet();
        for (Bean<Animal> animal : animals) {
            types.addAll(animal.getTypes());
        }
        assert (types.contains(Chicken.class));
        assert (types.contains(Cat.class));
        assert (!types.contains(Horse.class));
        assert (!types.contains(Dog.class));
        assert (this.getCurrentManager().getBeans("cat").size() == 1);
        assert (this.getCurrentManager().getBeans("dog").size() == 0);
    }

    @Test(groups={"alternatives"})
    @SpecAssertion(section="11.1", id="bc")
    public void testIsAlternative() {
        Bean cat = this.getCurrentManager().resolve(this.getCurrentManager().getBeans(Cat.class, new Annotation[0]));
        assert (cat.isAlternative());
    }

    @Test(groups={"alternatives"})
    @SpecAssertions(value={@SpecAssertion(section="5.1.1", id="g"), @SpecAssertion(section="2.6.1", id="b"), @SpecAssertion(section="2.7", id="aa"), @SpecAssertion(section="2.7.1.4", id="a")})
    public void testAnyEnabledAlternativeStereotypeMakesAlternativeEnabled() throws Exception {
        assert (this.getBeans(Bird.class, new Annotation[0]).size() == 1);
        assert (this.getCurrentManager().getBeans("bird").size() == 1);
    }

    @Test(groups={"alternatives"})
    @SpecAssertions(value={@SpecAssertion(section="5.1.1", id="fa")})
    public void testProducersOnAlternativeClass() throws Exception {
        assert (this.getBeans(Sheep.class, new Annotation[]{new AnnotationLiteral<Wild>(){}}).size() == 2);
        assert (this.getBeans(Sheep.class, new Annotation[]{new AnnotationLiteral<Tame>(){}}).size() == 0);
    }

    @Test(groups={"alternatives"})
    @SpecAssertions(value={@SpecAssertion(section="2.6.1", id="ab"), @SpecAssertion(section="2.6.1", id="ac")})
    public void testProducerAlternativesOnMethodAndField() throws Exception {
        assert (this.getBeans(Cat.class, new Annotation[]{new AnnotationLiteral<Wild>(){}}).size() == 2);
        assert (this.getBeans(Cat.class, new Annotation[]{new AnnotationLiteral<Tame>(){}}).size() == 0);
    }

    @Test(groups={"alternatives"})
    @SpecAssertions(value={@SpecAssertion(section="2.6.1", id="c"), @SpecAssertion(section="2.6.1", id="d")})
    public void testStereotypeAlternativeOnProducerMethodAndField() throws Exception {
        assert (this.getBeans(Bird.class, new Annotation[]{new AnnotationLiteral<Tame>(){}}).size() == 2);
        assert (this.getBeans(Bird.class, new Annotation[]{new AnnotationLiteral<Wild>(){}}).size() == 0);
    }
}

