/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.application;

import com.gargoylesoftware.htmlunit.TextPage;
import com.gargoylesoftware.htmlunit.WebClient;
import java.net.URL;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@Test(groups={"integration"})
@SpecVersion(spec="cdi", version="20091101")
public class ApplicationContextTest
extends AbstractTest {
    @ArquillianResource
    private URL contextPath;

    @Deployment(testable=false)
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(ApplicationContextTest.class)).withWebXml("web.xml")).withWebResource("SimplePage.html")).build();
    }

    @Test(groups={"contexts", "servlet"})
    @SpecAssertion(section="6.7.3", id="aa")
    public void testApplicationScopeActiveDuringServiceMethod() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        webClient.getPage(this.contextPath + "TestServlet?test=servlet");
    }

    @Test(groups={"contexts", "servlet"})
    @SpecAssertion(section="6.7.3", id="ab")
    public void testApplicationScopeActiveDuringDoFilterMethod() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        webClient.getPage(this.contextPath + "SimplePage.html");
    }

    @Test(groups={"contexts"})
    @SpecAssertion(section="6.7.3", id="ac")
    public void testApplicationScopeActiveDuringServletContextListenerInvocation() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        webClient.getPage(this.contextPath + "TestServlet?test=servletContextListener");
    }

    @Test(groups={"contexts"})
    @SpecAssertion(section="6.7.3", id="ad")
    public void testApplicationScopeActiveDuringHttpSessionListenerInvocation() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        webClient.getPage(this.contextPath + "TestServlet?test=httpSessionListener");
    }

    @Test(groups={"contexts"})
    @SpecAssertion(section="6.7.3", id="af")
    public void testApplicationScopeActiveDuringServletRequestListenerInvocation() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        webClient.getPage(this.contextPath + "TestServlet?test=servletRequestListener");
    }

    @Test(groups={"contexts"})
    @SpecAssertion(section="6.7.3", id="e")
    public void testApplicationContextSharedBetweenServletRequests() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        TextPage firstRequestResult = (TextPage)webClient.getPage(this.contextPath + "IntrospectApplication");
        assert (firstRequestResult.getContent() != null);
        assert (Double.parseDouble(firstRequestResult.getContent()) != 0.0);
        TextPage secondRequestResult = (TextPage)webClient.getPage(this.contextPath + "IntrospectApplication");
        assert (secondRequestResult.getContent() != null);
        assert (Double.parseDouble(secondRequestResult.getContent()) == Double.parseDouble(firstRequestResult.getContent()));
    }

    @Test(groups={"contexts"})
    @SpecAssertion(section="6.7.3", id="e")
    public void testApplicationContextSharedBetweenJaxRsRequests() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        TextPage firstRequestResult = (TextPage)webClient.getPage(this.contextPath + "jaxrs/application-id");
        assert (firstRequestResult.getContent() != null);
        assert (Double.parseDouble(firstRequestResult.getContent()) != 0.0);
        TextPage secondRequestResult = (TextPage)webClient.getPage(this.contextPath + "jaxrs/application-id");
        assert (secondRequestResult.getContent() != null);
        assert (Double.parseDouble(secondRequestResult.getContent()) == Double.parseDouble(firstRequestResult.getContent()));
    }
}

