/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.jms;

import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.Topic;
import org.jboss.cdi.tck.tests.context.jms.QueueMessageListener;
import org.jboss.cdi.tck.tests.context.jms.TopicMessageListener;

@ApplicationScoped
public class SimpleMessageConsumer {
    @Resource(mappedName="java:/ConnectionFactory")
    private static ConnectionFactory connectionFactory;
    @Resource(mappedName="java:/queue/test")
    private static Queue queue;
    @Resource(mappedName="java:/topic/test")
    private static Topic topic;
    @Inject
    private QueueMessageListener queueMessageListener;
    @Inject
    private TopicMessageListener topicMessageListener;
    private Connection connection = null;

    public void init() {
        Session session = null;
        MessageConsumer messageConsumer = null;
        try {
            this.connection = connectionFactory.createConnection();
            session = this.connection.createSession(false, 1);
            messageConsumer = session.createConsumer((Destination)queue);
            messageConsumer.setMessageListener((MessageListener)this.queueMessageListener);
            messageConsumer = session.createConsumer((Destination)topic);
            messageConsumer.setMessageListener((MessageListener)this.topicMessageListener);
            this.connection.start();
        }
        catch (JMSException e) {
            throw new RuntimeException("Cannot init message consumer");
        }
    }

    @PreDestroy
    public void destroy() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
    }
}

