/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.request;

import com.gargoylesoftware.htmlunit.TextPage;
import com.gargoylesoftware.htmlunit.WebClient;
import java.net.URL;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@Test(groups={"integration"})
@SpecVersion(spec="cdi", version="20091101")
public class RequestContextTest
extends AbstractTest {
    @ArquillianResource
    private URL contextPath;

    @Deployment(testable=false)
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(RequestContextTest.class)).withWebResource("SimplePage.html", "SimplePage.html")).withWebXml("web.xml")).build();
    }

    @Test(groups={"contexts", "servlet"})
    @SpecAssertion(section="6.7.1", id="aa")
    public void testRequestScopeActiveDuringServiceMethod() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        webClient.getPage(this.contextPath + "serviceMethodTest");
    }

    @Test(groups={"contexts", "servlet"})
    @SpecAssertion(section="6.7.1", id="ab")
    public void testRequestScopeActiveDuringServletFilter() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        webClient.getPage(this.contextPath + "SimplePage.html");
    }

    @Test(groups={"contexts", "servlet", "rewrite"})
    @SpecAssertion(section="6.7.1", id="baa")
    public void testRequestScopeIsDestroyedAfterServletRequest() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        TextPage firstRequestResult = (TextPage)webClient.getPage(this.contextPath + "IntrospectRequest");
        assert (firstRequestResult.getContent() != null);
        assert (Double.parseDouble(firstRequestResult.getContent()) != 0.0);
        TextPage secondRequestResult = (TextPage)webClient.getPage(this.contextPath + "IntrospectRequest");
        assert (secondRequestResult.getContent() != null);
        assert (Double.parseDouble(secondRequestResult.getContent()) != Double.parseDouble(firstRequestResult.getContent()));
    }
}

