/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.definition.bean;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.util.AnnotationLiteral;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.definition.bean.AbstractAntelope;
import org.jboss.cdi.tck.tests.definition.bean.Animal;
import org.jboss.cdi.tck.tests.definition.bean.ComplicatedTuna;
import org.jboss.cdi.tck.tests.definition.bean.DeadlyAnimal;
import org.jboss.cdi.tck.tests.definition.bean.DeadlySpider;
import org.jboss.cdi.tck.tests.definition.bean.DependentFinalTuna;
import org.jboss.cdi.tck.tests.definition.bean.FriendlyAntelope;
import org.jboss.cdi.tck.tests.definition.bean.Horse;
import org.jboss.cdi.tck.tests.definition.bean.RedSnapper;
import org.jboss.cdi.tck.tests.definition.bean.Spider;
import org.jboss.cdi.tck.tests.definition.bean.Tame;
import org.jboss.cdi.tck.tests.definition.bean.Tarantula;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class BeanDefinitionTest
extends AbstractTest {
    private static Annotation TAME_LITERAL = new AnnotationLiteral<Tame>(){};

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(BeanDefinitionTest.class)).build();
    }

    @Test
    @SpecAssertion(section="2", id="a")
    public void testBeanTypesNonEmpty() {
        assert (this.getBeans(RedSnapper.class, new Annotation[0]).size() == 1);
        assert (this.getBeans(RedSnapper.class, new Annotation[0]).iterator().next().getTypes().size() > 0);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="2", id="b"), @SpecAssertion(section="11.1", id="ba")})
    public void testQualifiersNonEmpty() {
        assert (this.getBeans(RedSnapper.class, new Annotation[0]).size() == 1);
        assert (this.getBeans(RedSnapper.class, new Annotation[0]).iterator().next().getQualifiers().size() > 0);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="2", id="c"), @SpecAssertion(section="2.4", id="a"), @SpecAssertion(section="3.1.3", id="ba"), @SpecAssertion(section="11.1", id="ba")})
    public void testHasScopeType() {
        assert (this.getBeans(RedSnapper.class, new Annotation[0]).size() == 1);
        assert (this.getBeans(RedSnapper.class, new Annotation[0]).iterator().next().getScope().equals(RequestScoped.class));
    }

    @Test(groups={"producerMethod"})
    @SpecAssertions(value={@SpecAssertion(section="2.2.1", id="j"), @SpecAssertion(section="5.2.4", id="ba"), @SpecAssertion(section="11.1", id="bd")})
    public void testIsNullable() throws Exception {
        assert (this.getBeans(Integer.TYPE, new Annotation[0]).size() == 1);
        Bean<Integer> bean = this.getBeans(Integer.TYPE, new Annotation[0]).iterator().next();
        assert (!bean.isNullable());
        assert (this.getBeans(Animal.class, TAME_LITERAL).size() == 1);
        Bean<Animal> animalBean = this.getBeans(Animal.class, TAME_LITERAL).iterator().next();
        assert (animalBean.isNullable());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="3.1.2", id="a"), @SpecAssertion(section="2.2", id="a"), @SpecAssertion(section="2.2.1", id="a"), @SpecAssertion(section="2.2.1", id="d"), @SpecAssertion(section="2.2.1", id="e"), @SpecAssertion(section="2.2", id="l"), @SpecAssertion(section="11.1", id="ba")})
    public void testBeanTypes() {
        assert (this.getBeans(Tarantula.class, new Annotation[0]).size() == 1);
        Bean<Tarantula> bean = this.getBeans(Tarantula.class, new Annotation[0]).iterator().next();
        assert (bean.getTypes().size() == 6);
        assert (bean.getTypes().contains(Tarantula.class));
        assert (bean.getTypes().contains(Spider.class));
        assert (bean.getTypes().contains(Animal.class));
        assert (bean.getTypes().contains(Object.class));
        assert (bean.getTypes().contains(DeadlySpider.class));
        assert (bean.getTypes().contains(DeadlyAnimal.class));
    }

    @Test
    @SpecAssertion(section="2.2.3", id="a")
    public void testBeanClientCanCastBeanInstanceToAnyBeanType() {
        Tarantula tarantula;
        assert (this.getBeans(Tarantula.class, new Annotation[0]).size() == 1);
        Bean<Tarantula> bean = this.getBeans(Tarantula.class, new Annotation[0]).iterator().next();
        Tarantula spider = tarantula = (Tarantula)this.getCurrentManager().getContext(bean.getScope()).get(bean);
        Tarantula animal = tarantula;
        Tarantula obj = tarantula;
        Tarantula deadlySpider = tarantula;
        Tarantula deadlyAnimal = tarantula;
    }

    @Test
    @SpecAssertion(section="2.2.1", id="c")
    public void testAbstractApiType() {
        assert (this.getBeans(FriendlyAntelope.class, new Annotation[0]).size() == 1);
        Bean<FriendlyAntelope> bean = this.getBeans(FriendlyAntelope.class, new Annotation[0]).iterator().next();
        assert (bean.getTypes().size() == 4);
        assert (bean.getTypes().contains(FriendlyAntelope.class));
        assert (bean.getTypes().contains(AbstractAntelope.class));
        assert (bean.getTypes().contains(Animal.class));
        assert (bean.getTypes().contains(Object.class));
    }

    @Test
    @SpecAssertion(section="2.2.1", id="d")
    public void testFinalApiType() {
        assert (!this.getBeans(DependentFinalTuna.class, new Annotation[0]).isEmpty());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="3.1.3", id="bd"), @SpecAssertion(section="11.1", id="ba")})
    public void testMultipleStereotypes() {
        Bean<ComplicatedTuna> tunaBean = this.getBeans(ComplicatedTuna.class, new Annotation[0]).iterator().next();
        assert (tunaBean.getScope().equals(RequestScoped.class));
        assert (tunaBean.getName().equals("complicatedTuna"));
    }

    @Test
    @SpecAssertion(section="3.1.3", id="c")
    public void testBeanExtendsAnotherBean() {
        assert (!this.getBeans(Spider.class, new Annotation[0]).isEmpty());
        assert (!this.getBeans(Tarantula.class, new Annotation[0]).isEmpty());
    }

    @Test
    @SpecAssertion(section="11.1", id="bb")
    public void testBeanClassOnSimpleBean() {
        Set<Bean<Horse>> beans = this.getBeans(Horse.class, new Annotation[0]);
        assert (beans.size() == 1);
        assert (beans.iterator().next().getBeanClass().equals(Horse.class));
    }
}

