/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.deployment.lifecycle;

import javax.decorator.Decorator;
import javax.decorator.Delegate;
import javax.inject.Inject;
import org.jboss.cdi.tck.tests.deployment.lifecycle.DataAccess;
import org.jboss.cdi.tck.tests.deployment.lifecycle.NotAuthorizedException;
import org.jboss.cdi.tck.tests.deployment.lifecycle.User;

@Decorator
public class DataAccessAuthorizationDecorator
implements DataAccess {
    @Inject
    @Delegate
    DataAccess delegate;
    @Inject
    User user;

    @Override
    public void save() {
        this.authorize("save");
        this.delegate.save();
    }

    @Override
    public void delete() {
        this.authorize("delete");
        this.delegate.delete();
    }

    private void authorize(String action) {
        Object id = this.delegate.getId();
        Class<?> type = this.delegate.getDataType();
        if (!this.user.hasPermission(action, type, id)) {
            System.out.println("Not authorized for " + action);
            throw new NotAuthorizedException(action);
        }
        System.out.println("Authorized for " + action);
    }

    @Override
    public Class<?> getDataType() {
        return this.delegate.getDataType();
    }

    @Override
    public Object getId() {
        return this.delegate.getId();
    }

    @Override
    public Object load(Object id) {
        return this.delegate.load(id);
    }
}

