/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.event.eventTypes;

import java.lang.annotation.Annotation;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.event.eventTypes.Broadcast;
import org.jboss.cdi.tck.tests.event.eventTypes.ComplexEvent;
import org.jboss.cdi.tck.tests.event.eventTypes.EventTypeFamilyObserver;
import org.jboss.cdi.tck.tests.event.eventTypes.Listener;
import org.jboss.cdi.tck.tests.event.eventTypes.Song;
import org.jboss.cdi.tck.tests.event.eventTypes.TuneSelect;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class EventTypesTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(EventTypesTest.class)).build();
    }

    @Test(groups={"events"})
    @SpecAssertions(value={@SpecAssertion(section="10.1", id="aa"), @SpecAssertion(section="10.1", id="j")})
    public void testEventTypeIsConcreteTypeWithNoTypeVariables() {
        Listener listener = this.getInstanceByType(Listener.class, new Annotation[0]);
        listener.reset();
        Song s = new Song();
        this.getInstanceByType(TuneSelect.class, new Annotation[0]).songPlaying(s);
        assert (listener.getObjectsFired().size() == 1);
        assert (listener.getObjectsFired().get(0) == s);
        this.getCurrentManager().fireEvent((Object)s, new Annotation[0]);
        assert (listener.getObjectsFired().size() == 2);
        assert (listener.getObjectsFired().get(1) == s);
        Broadcast b = new Broadcast(){};
        this.getInstanceByType(TuneSelect.class, new Annotation[0]).broadcastPlaying(b);
        assert (listener.getObjectsFired().size() == 3);
        assert (listener.getObjectsFired().get(2) == b);
        this.getCurrentManager().fireEvent((Object)1, new Annotation[0]);
        assert (listener.getObjectsFired().size() == 4);
        assert (listener.getObjectsFired().get(3).equals(1));
    }

    @Test(groups={"events"})
    @SpecAssertion(section="10.1", id="c")
    public void testEventTypeIncludesAllSuperclassesAndInterfacesOfEventObject() {
        EventTypeFamilyObserver observer = this.getInstanceByType(EventTypeFamilyObserver.class, new Annotation[0]);
        this.getCurrentManager().fireEvent((Object)new ComplexEvent(), new Annotation[0]);
        assert (observer.getGeneralEventQuantity() == 1);
        assert (observer.getAbstractEventQuantity() == 1);
        assert (observer.getComplexEventQuantity() == 1);
        assert (observer.getObjectEventQuantity() == 1);
        assert (observer.getTotalEventsObserved() == 4);
    }
}

