/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.event.observer;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.enterprise.event.Reception;
import javax.enterprise.inject.spi.ObserverMethod;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.event.observer.AnEventType;
import org.jboss.cdi.tck.tests.event.observer.AnObserver;
import org.jboss.cdi.tck.tests.event.observer.AnotherObserver;
import org.jboss.cdi.tck.tests.event.observer.ConditionalEvent;
import org.jboss.cdi.tck.tests.event.observer.LastObserver;
import org.jboss.cdi.tck.tests.event.observer.RoleBinding;
import org.jboss.cdi.tck.tests.event.observer.StockPrice;
import org.jboss.cdi.tck.tests.event.observer.StockWatcher;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class ObserverTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(ObserverTest.class)).build();
    }

    @Test(groups={"events"})
    @SpecAssertions(value={@SpecAssertion(section="10.2", id="i"), @SpecAssertion(section="10.5", id="aa")})
    public void testObserverNotifiedWhenEventTypeAndAllBindingsMatch() {
        RoleBinding roleBinding = new RoleBinding("Admin");
        AnEventType anEvent = new AnEventType();
        this.getCurrentManager().fireEvent((Object)anEvent, new Annotation[]{roleBinding});
        assert (AnObserver.wasNotified);
        assert (AnotherObserver.wasNotified);
        assert (LastObserver.wasNotified);
        AnObserver.wasNotified = false;
        AnotherObserver.wasNotified = false;
        LastObserver.wasNotified = false;
        this.getCurrentManager().fireEvent((Object)anEvent, new Annotation[0]);
        assert (AnObserver.wasNotified);
        assert (!AnotherObserver.wasNotified);
        assert (LastObserver.wasNotified);
        AnObserver.wasNotified = false;
        AnotherObserver.wasNotified = false;
        LastObserver.wasNotified = false;
        this.getCurrentManager().fireEvent((Object)anEvent, new Annotation[]{new RoleBinding("user")});
        assert (AnObserver.wasNotified);
        assert (!AnotherObserver.wasNotified);
        assert (LastObserver.wasNotified);
    }

    @Test(groups={"events"})
    @SpecAssertion(section="11.1.3", id="b")
    public void testGetBeanOnObserverMethod() {
        Set observers = this.getCurrentManager().resolveObserverMethods((Object)new StockPrice(), new Annotation[0]);
        assert (observers.size() == 1);
        ObserverMethod observerMethod = (ObserverMethod)observers.iterator().next();
        assert (observerMethod.getBeanClass().equals(StockWatcher.class));
    }

    @Test(groups={"events"})
    @SpecAssertion(section="11.1.3", id="c")
    public void testGetObservedTypeOnObserverMethod() {
        Set observers = this.getCurrentManager().resolveObserverMethods((Object)new StockPrice(), new Annotation[0]);
        assert (observers.size() == 1);
        ObserverMethod observerMethod = (ObserverMethod)observers.iterator().next();
        assert (observerMethod.getObservedType().equals(StockPrice.class));
    }

    @Test(groups={"events"})
    @SpecAssertion(section="11.1.3", id="c")
    public void testGetObservedBindingsOnObserverMethod() {
        Set observers = this.getCurrentManager().resolveObserverMethods((Object)new StockPrice(), new Annotation[0]);
        assert (observers.size() == 1);
        ObserverMethod observerMethod = (ObserverMethod)observers.iterator().next();
        assert (observerMethod.getObservedQualifiers().isEmpty());
    }

    @Test(groups={"events"})
    @SpecAssertion(section="11.1.3", id="d")
    public void testGetNotifyOnObserverMethod() {
        Set observers = this.getCurrentManager().resolveObserverMethods((Object)new StockPrice(), new Annotation[0]);
        assert (observers.size() == 1);
        assert (((ObserverMethod)observers.iterator().next()).getReception().equals((Object)Reception.ALWAYS));
        Set conditionalObservers = this.getCurrentManager().resolveObserverMethods((Object)new ConditionalEvent(), new Annotation[0]);
        assert (!conditionalObservers.isEmpty());
        assert (((ObserverMethod)conditionalObservers.iterator().next()).getReception().equals((Object)Reception.IF_EXISTS));
    }
}

