/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.event.observer.transactional;

import javax.annotation.Resource;
import javax.ejb.Stateless;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import javax.transaction.UserTransaction;
import org.jboss.cdi.tck.tests.event.observer.transactional.Withdrawal;

@Named
@Stateless
@TransactionManagement(value=TransactionManagementType.BEAN)
public class AccountService {
    @Resource
    private UserTransaction userTransaction;
    @Inject
    Event<Withdrawal> event;

    public long withdrawSuccesTransaction(int amount) throws Exception {
        this.userTransaction.begin();
        this.event.fire((Object)new Withdrawal(amount));
        long checkpoint = this.now();
        this.userTransaction.commit();
        return checkpoint;
    }

    public long withdrawFailedTransaction(int amount) throws Exception {
        this.userTransaction.begin();
        this.event.fire((Object)new Withdrawal(amount));
        long checkpoint = this.now();
        this.userTransaction.rollback();
        return checkpoint;
    }

    public long withdrawNoTransaction(int amount) throws Exception {
        this.event.fire((Object)new Withdrawal(amount));
        return this.now();
    }

    private long now() {
        return System.currentTimeMillis();
    }
}

