/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.event.observer.transactional;

import javax.enterprise.event.Observes;
import javax.enterprise.event.TransactionPhase;
import org.jboss.cdi.tck.tests.event.observer.transactional.Withdrawal;

public class AccountTransactionObserver {
    public static long beforeCompletionObservedTime = 0L;
    public static long afterCompletionObservedTime = 0L;
    public static long afterSuccessObservedTime = 0L;
    public static long afterFailureObservedTime = 0L;
    public static long noTxObservedTime = 0L;

    public void withdrawAfterSuccess(@Observes(during=TransactionPhase.AFTER_SUCCESS) Withdrawal withdrawal) throws Exception {
        this.logEventFired(TransactionPhase.AFTER_SUCCESS);
        afterSuccessObservedTime = this.now();
        this.pause();
    }

    public void withdrawAfterCompletion(@Observes(during=TransactionPhase.AFTER_COMPLETION) Withdrawal withdrawal) throws Exception {
        this.logEventFired(TransactionPhase.AFTER_COMPLETION);
        afterCompletionObservedTime = this.now();
        this.pause();
    }

    public void withdrawBeforeCompletion(@Observes(during=TransactionPhase.BEFORE_COMPLETION) Withdrawal withdrawal) throws Exception {
        this.logEventFired(TransactionPhase.BEFORE_COMPLETION);
        beforeCompletionObservedTime = this.now();
        this.pause();
    }

    public void withdrawNoTx(@Observes(during=TransactionPhase.IN_PROGRESS) Withdrawal withdrawal) throws Exception {
        noTxObservedTime = this.now();
        this.pause();
    }

    public void withdrawAfterFailure(@Observes(during=TransactionPhase.AFTER_FAILURE) Withdrawal withdrawal) throws Exception {
        this.logEventFired(TransactionPhase.AFTER_FAILURE);
        afterFailureObservedTime = this.now();
        this.pause();
    }

    private long now() {
        return System.currentTimeMillis();
    }

    private void pause() throws Exception {
        Thread.sleep(500L);
    }

    private void logEventFired(TransactionPhase phase) {
        System.out.println(phase);
    }

    public static void reset() {
        beforeCompletionObservedTime = 0L;
        afterCompletionObservedTime = 0L;
        afterSuccessObservedTime = 0L;
        afterFailureObservedTime = 0L;
        noTxObservedTime = 0L;
    }

    public static boolean allEventsFiredBeforeCheckpoint(long checkpoint) {
        return AccountTransactionObserver.isEventFiredBeforeCheckpoint(beforeCompletionObservedTime, checkpoint) && AccountTransactionObserver.isEventFiredBeforeCheckpoint(afterCompletionObservedTime, checkpoint) && AccountTransactionObserver.isEventFiredBeforeCheckpoint(afterSuccessObservedTime, checkpoint) && AccountTransactionObserver.isEventFiredBeforeCheckpoint(afterFailureObservedTime, checkpoint) && AccountTransactionObserver.isEventFiredBeforeCheckpoint(noTxObservedTime, checkpoint);
    }

    private static boolean isEventFiredBeforeCheckpoint(long fireTime, long checkpoint) {
        return fireTime > 0L && fireTime < checkpoint;
    }
}

