/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.event.observer.transactional;

import javax.inject.Inject;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.event.observer.transactional.AccountService;
import org.jboss.cdi.tck.tests.event.observer.transactional.AccountTransactionObserver;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"integration"})
@SpecVersion(spec="cdi", version="20091101")
public class TransactionalObserverTest
extends AbstractTest {
    @Inject
    AccountService accountService;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(TransactionalObserverTest.class)).withDefaultPersistenceXml()).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="10.4.4", id="a"), @SpecAssertion(section="10.4.4", id="b"), @SpecAssertion(section="10.4.4", id="c"), @SpecAssertion(section="10.4.4", id="d"), @SpecAssertion(section="10.4.4", id="e"), @SpecAssertion(section="10.4.4", id="gaa"), @SpecAssertion(section="10.5", id="bb")})
    public void testSucessfullTransaction() throws Exception {
        this.logTestMethod("testSucessfullTransaction");
        AccountTransactionObserver.reset();
        long checkpoint = this.accountService.withdrawSuccesTransaction(1);
        Assert.assertTrue((AccountTransactionObserver.beforeCompletionObservedTime > checkpoint ? 1 : 0) != 0);
        Assert.assertTrue((AccountTransactionObserver.afterSuccessObservedTime > AccountTransactionObserver.beforeCompletionObservedTime ? 1 : 0) != 0);
        Assert.assertTrue((AccountTransactionObserver.afterCompletionObservedTime > AccountTransactionObserver.beforeCompletionObservedTime ? 1 : 0) != 0);
        Assert.assertTrue((AccountTransactionObserver.afterFailureObservedTime == 0L ? 1 : 0) != 0);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="10.4.4", id="a"), @SpecAssertion(section="10.4.4", id="b"), @SpecAssertion(section="10.4.4", id="c"), @SpecAssertion(section="10.4.4", id="d"), @SpecAssertion(section="10.4.4", id="e"), @SpecAssertion(section="10.4.4", id="gaa"), @SpecAssertion(section="10.5", id="bb")})
    public void testFailedTransaction() throws Exception {
        this.logTestMethod("testFailedTransaction");
        AccountTransactionObserver.reset();
        long checkpoint = this.accountService.withdrawFailedTransaction(2);
        Assert.assertTrue((AccountTransactionObserver.afterCompletionObservedTime > checkpoint ? 1 : 0) != 0);
        Assert.assertTrue((AccountTransactionObserver.afterFailureObservedTime > checkpoint ? 1 : 0) != 0);
        Assert.assertTrue((AccountTransactionObserver.afterSuccessObservedTime == 0L ? 1 : 0) != 0);
        Assert.assertTrue((AccountTransactionObserver.beforeCompletionObservedTime == 0L ? 1 : 0) != 0);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="10.4.4", id="a"), @SpecAssertion(section="10.5", id="bc")})
    public void testNoTransaction() throws Exception {
        this.logTestMethod("testNoTransaction");
        AccountTransactionObserver.reset();
        long checkpoint = this.accountService.withdrawNoTransaction(3);
        Assert.assertTrue((boolean)AccountTransactionObserver.allEventsFiredBeforeCheckpoint(checkpoint));
    }

    private void logTestMethod(String methodName) {
        System.out.println(methodName);
    }
}

