/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.extensions.beanManager;

import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.inject.AmbiguousResolutionException;
import javax.enterprise.inject.InjectionException;
import javax.enterprise.inject.Specializes;
import javax.enterprise.inject.Stereotype;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.util.AnnotationLiteral;
import javax.interceptor.InterceptorBinding;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.literals.RetentionLiteral;
import org.jboss.cdi.tck.literals.TargetLiteral;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.extensions.alternative.metadata.AnnotatedTypeWrapper;
import org.jboss.cdi.tck.tests.extensions.alternative.metadata.AnnotatedWrapper;
import org.jboss.cdi.tck.tests.extensions.beanManager.AfterBeanDiscoveryObserver;
import org.jboss.cdi.tck.tests.extensions.beanManager.AnimalStereotype;
import org.jboss.cdi.tck.tests.extensions.beanManager.DerivedBean;
import org.jboss.cdi.tck.tests.extensions.beanManager.Dog;
import org.jboss.cdi.tck.tests.extensions.beanManager.DogHouse;
import org.jboss.cdi.tck.tests.extensions.beanManager.InjectionPointDecorator;
import org.jboss.cdi.tck.tests.extensions.beanManager.ProcessAnnotatedTypeObserver;
import org.jboss.cdi.tck.tests.extensions.beanManager.SimpleBean;
import org.jboss.cdi.tck.tests.extensions.beanManager.Tame;
import org.jboss.cdi.tck.tests.extensions.beanManager.Terrier;
import org.jboss.cdi.tck.tests.extensions.beanManager.Transactional;
import org.jboss.cdi.tck.tests.extensions.beanManager.UnregisteredExtension;
import org.jboss.cdi.tck.tests.extensions.beanManager.WrappedBean;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"integration"})
@SpecVersion(spec="cdi", version="20091101")
public class BeanManagerTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(BeanManagerTest.class)).withClasses(AnnotatedTypeWrapper.class, AnnotatedWrapper.class)).withExtensions(AfterBeanDiscoveryObserver.class, ProcessAnnotatedTypeObserver.class)).build();
    }

    @Test
    @SpecAssertion(section="11.3.8", id="a")
    public void testAmbiguousDependencyResolved() {
        HashSet beans = new HashSet();
        beans.addAll(this.getCurrentManager().getBeans(SimpleBean.class, new Annotation[0]));
        beans.addAll(this.getCurrentManager().getBeans(DerivedBean.class, new Annotation[0]));
        this.getCurrentManager().resolve(beans);
    }

    @Test(expectedExceptions={AmbiguousResolutionException.class})
    @SpecAssertion(section="11.3.8", id="b")
    public void testAmbiguousDependencyNotResolved() {
        HashSet beans = new HashSet();
        beans.addAll(this.getCurrentManager().getBeans(Dog.class, new Annotation[0]));
        beans.addAll(this.getCurrentManager().getBeans(Terrier.class, new Annotation[0]));
        this.getCurrentManager().resolve(beans);
    }

    @Test(expectedExceptions={InjectionException.class})
    @SpecAssertion(section="11.3.9", id="a")
    public void testValidateThrowsException() {
        DogHouse dogHouse = this.getInstanceByType(DogHouse.class, new Annotation[0]);
        InjectionPointDecorator injectionPoint = new InjectionPointDecorator(dogHouse.getDog().getInjectedMetadata());
        this.getCurrentManager().validate((InjectionPoint)injectionPoint);
    }

    @Test(groups={"rewrite"})
    @SpecAssertion(section="11.3.14", id="aa")
    public void testDetermineBindingType() {
        assert (this.getCurrentManager().isQualifier(Tame.class));
        assert (!this.getCurrentManager().isQualifier(AnimalStereotype.class));
        assert (!this.getCurrentManager().isQualifier(ApplicationScoped.class));
        assert (!this.getCurrentManager().isQualifier(Transactional.class));
    }

    @Test(groups={"rewrite"})
    @SpecAssertion(section="11.3.14", id="ab")
    public void testDetermineScopeType() {
        assert (this.getCurrentManager().isScope(ApplicationScoped.class));
        assert (!this.getCurrentManager().isScope(Tame.class));
        assert (!this.getCurrentManager().isScope(AnimalStereotype.class));
        assert (!this.getCurrentManager().isScope(Transactional.class));
    }

    @Test(groups={"rewrite"})
    @SpecAssertion(section="11.3.14", id="ac")
    public void testDetermineStereotype() {
        assert (this.getCurrentManager().isStereotype(AnimalStereotype.class));
        assert (!this.getCurrentManager().isStereotype(Tame.class));
        assert (!this.getCurrentManager().isStereotype(ApplicationScoped.class));
        assert (!this.getCurrentManager().isStereotype(Transactional.class));
    }

    @Test(groups={"rewrite"})
    @SpecAssertion(section="11.3.14", id="ad")
    public void testDetermineInterceptorBindingType() {
        assert (this.getCurrentManager().isInterceptorBinding(Transactional.class));
        assert (!this.getCurrentManager().isInterceptorBinding(Tame.class));
        assert (!this.getCurrentManager().isInterceptorBinding(AnimalStereotype.class));
        assert (!this.getCurrentManager().isInterceptorBinding(ApplicationScoped.class));
    }

    @Test(groups={"rewrite"})
    @SpecAssertion(section="11.3.14", id="ae")
    public void testGetMetaAnnotationsForStereotype() {
        Set stereotypeAnnotations = this.getCurrentManager().getStereotypeDefinition(AnimalStereotype.class);
        assert (stereotypeAnnotations.size() == 5);
        assert (stereotypeAnnotations.contains(new AnnotationLiteral<Stereotype>(){}));
        assert (stereotypeAnnotations.contains(new AnnotationLiteral<RequestScoped>(){}));
        assert (stereotypeAnnotations.contains(new AnnotationLiteral<Inherited>(){}));
        assert (stereotypeAnnotations.contains(new RetentionLiteral(){

            @Override
            public RetentionPolicy value() {
                return RetentionPolicy.RUNTIME;
            }
        }));
        assert (stereotypeAnnotations.contains(new TargetLiteral(){

            @Override
            public ElementType[] value() {
                ElementType[] value = new ElementType[]{ElementType.TYPE, ElementType.METHOD, ElementType.FIELD};
                return value;
            }
        }));
    }

    @Test(groups={"rewrite"})
    @SpecAssertion(section="11.3.14", id="af")
    public void testGetMetaAnnotationsForInterceptorBindingType() {
        Set metaAnnotations = this.getCurrentManager().getInterceptorBindingDefinition(Transactional.class);
        assert (metaAnnotations.size() == 4);
        assert (this.annotationSetMatches((Set<? extends Annotation>)metaAnnotations, Target.class, Retention.class, Documented.class, InterceptorBinding.class));
    }

    @Test(groups={"rewrite"})
    @SpecAssertion(section="11.3.14", id="ag")
    public void testgetScope() {
        assert (this.getCurrentManager().isNormalScope(RequestScoped.class));
        assert (!this.getCurrentManager().isPassivatingScope(RequestScoped.class));
        assert (this.getCurrentManager().isNormalScope(SessionScoped.class));
        assert (this.getCurrentManager().isPassivatingScope(SessionScoped.class));
    }

    @Test
    @SpecAssertion(section="11.3.16", id="a")
    public void testGetELResolver() {
        assert (this.getCurrentManager().getELResolver() != null);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="11.3.18", id="a")})
    public void testObtainingAnnotatedType() {
        AnnotatedType annotatedType = this.getCurrentManager().createAnnotatedType(DerivedBean.class);
        Assert.assertTrue((boolean)annotatedType.isAnnotationPresent(Specializes.class));
        Assert.assertTrue((boolean)annotatedType.isAnnotationPresent(Tame.class));
        Assert.assertEquals((int)1, (int)annotatedType.getFields().size());
        Assert.assertTrue((boolean)annotatedType.getMethods().isEmpty());
        Assert.assertEquals((int)3, (int)annotatedType.getTypeClosure().size());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="11.3.18", id="b")})
    public void testObtainingWrappedAnnotatedType() {
        AnnotatedType annotatedType = this.getCurrentManager().createAnnotatedType(WrappedBean.class);
        Assert.assertTrue((boolean)annotatedType.isAnnotationPresent(Tame.class));
        Assert.assertTrue((boolean)annotatedType.isAnnotationPresent(Transactional.class));
        Assert.assertTrue((boolean)annotatedType.getFields().isEmpty());
        Assert.assertTrue((boolean)annotatedType.getMethods().isEmpty());
        Assert.assertEquals((int)2, (int)annotatedType.getTypeClosure().size());
    }

    @Test
    @SpecAssertion(section="11.3.19", id="aa")
    public void testObtainingInjectionTarget() {
        AnnotatedType annotatedType = this.getCurrentManager().createAnnotatedType(DerivedBean.class);
        assert (this.getCurrentManager().createInjectionTarget(annotatedType) != null);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="11.3.24", id="a"), @SpecAssertion(section="11.3.24", id="b")})
    public void testGetExtension() {
        AfterBeanDiscoveryObserver extension = (AfterBeanDiscoveryObserver)this.getCurrentManager().getExtension(AfterBeanDiscoveryObserver.class);
        Assert.assertNotNull((Object)extension);
        Assert.assertTrue((boolean)extension.getAfterBeanDiscoveryObserved());
        try {
            this.getCurrentManager().getExtension(UnregisteredExtension.class);
        }
        catch (Throwable t) {
            Assert.assertTrue((boolean)this.isThrowablePresent(IllegalArgumentException.class, t));
            return;
        }
        Assert.fail();
    }
}

