/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.implementation.enterprise.lifecycle;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.util.AnnotationLiteral;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.implementation.enterprise.lifecycle.AlteStadt;
import org.jboss.cdi.tck.tests.implementation.enterprise.lifecycle.DirectOrderProcessorLocal;
import org.jboss.cdi.tck.tests.implementation.enterprise.lifecycle.GeschichtslosStadt;
import org.jboss.cdi.tck.tests.implementation.enterprise.lifecycle.GrossStadt;
import org.jboss.cdi.tck.tests.implementation.enterprise.lifecycle.Important;
import org.jboss.cdi.tck.tests.implementation.enterprise.lifecycle.KleinStadt;
import org.jboss.cdi.tck.tests.implementation.enterprise.lifecycle.NeueStadt;
import org.jboss.cdi.tck.tests.implementation.enterprise.lifecycle.OrderProcessor;
import org.jboss.cdi.tck.tests.implementation.enterprise.lifecycle.OrderProcessorLocal;
import org.jboss.cdi.tck.tests.implementation.enterprise.lifecycle.SchoeneStadt;
import org.jboss.cdi.tck.tests.implementation.enterprise.lifecycle.UniStadt;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class EnterpriseBeanLifecycleTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(EnterpriseBeanLifecycleTest.class)).build();
    }

    @Test(groups={"integration", "lifecycle"})
    @SpecAssertions(value={@SpecAssertion(section="7.3.2", id="aa"), @SpecAssertion(section="7.3.2", id="bb"), @SpecAssertion(section="6.5.3", id="b"), @SpecAssertion(section="12.1", id="bba")})
    public void testCreateSFSB() throws Exception {
        GrossStadt frankfurt = this.getInstanceByType(GrossStadt.class, new Annotation[0]);
        Bean<KleinStadt> stadtBean = this.getBeans(KleinStadt.class, new Annotation[0]).iterator().next();
        assert (stadtBean != null) : "Expected a bean for stateful session bean Kassel";
        KleinStadt stadtInstance = this.getInstanceByType(KleinStadt.class, new Annotation[]{new AnnotationLiteral<Important>(){}});
        assert (stadtInstance != null) : "Expected instance to be created by container";
        assert (frankfurt.isKleinStadtCreated()) : "PostConstruct should be invoked when bean instance is created";
        frankfurt.resetCreatedFlags();
        KleinStadt anotherStadtInstance = this.getInstanceByType(KleinStadt.class, new Annotation[]{new AnnotationLiteral<Important>(){}});
        assert (anotherStadtInstance != null) : "Expected second instance of session bean";
        assert (frankfurt.isKleinStadtCreated());
        assert (anotherStadtInstance != stadtInstance) : "create() should not return same bean as before";
        stadtInstance.setName("hometown");
        assert ("hometown".equals(stadtInstance.getName()));
        assert (this.getCurrentConfiguration().getBeans().isProxy((Object)stadtInstance));
        HashSet interfaces = new HashSet(Arrays.asList(stadtInstance.getClass().getInterfaces()));
        assert (interfaces.contains(KleinStadt.class));
        assert (interfaces.contains(SchoeneStadt.class));
        assert (interfaces.contains(Serializable.class));
    }

    @Test(groups={"integration", "lifecycle"})
    @SpecAssertions(value={@SpecAssertion(section="6.6.2", id="a")})
    public void testSerializeSFSB() throws Exception {
        KleinStadt stadtInstance = this.getInstanceByType(KleinStadt.class, new Annotation[]{new AnnotationLiteral<Important>(){}});
        byte[] bytes = this.serialize(stadtInstance);
        Object object = this.deserialize(bytes);
        stadtInstance = (KleinStadt)object;
        assert (this.getCurrentConfiguration().getBeans().isProxy((Object)stadtInstance));
    }

    @Test(groups={"integration", "lifecycle"})
    @SpecAssertions(value={@SpecAssertion(section="7.3.2", id="bc"), @SpecAssertion(section="7.3.3", id="c")})
    public void testDestroyRemovesSFSB() throws Exception {
        GrossStadt frankfurt = this.getInstanceByType(GrossStadt.class, new Annotation[0]);
        Bean<KleinStadt> stadtBean = this.getBeans(KleinStadt.class, new Annotation[0]).iterator().next();
        assert (stadtBean != null) : "Expected a bean for stateful session bean Kassel";
        Context requestContext = this.getCurrentManager().getContext(RequestScoped.class);
        CreationalContext creationalContext = this.getCurrentManager().createCreationalContext(stadtBean);
        KleinStadt kassel = (KleinStadt)stadtBean.create(creationalContext);
        kassel.ping();
        stadtBean.destroy((Object)kassel, creationalContext);
        assert (frankfurt.isKleinStadtDestroyed()) : "Expected SFSB bean to be destroyed";
        kassel = (KleinStadt)requestContext.get(stadtBean);
        assert (kassel == null) : "SFSB bean should not exist after being destroyed";
    }

    @Test(groups={"integration", "lifecycle"})
    @SpecAssertions(value={@SpecAssertion(section="7.3.2", id="bc"), @SpecAssertion(section="3.2.1", id="dba")})
    public void testRemovedEjbIgnored() {
        KleinStadt stadtInstance = this.getInstanceByType(KleinStadt.class, new Annotation[]{new AnnotationLiteral<Important>(){}});
        assert (stadtInstance != null) : "Expected instance to be created by container";
        stadtInstance.setName("Kassel-Wilhelmshoehe");
        stadtInstance.zustandVergessen();
        KleinStadt newStadtInstance = this.getInstanceByType(KleinStadt.class, new Annotation[0]);
        assert (newStadtInstance != null) : "Failed to get SFSB instance the second time";
        assert (!"Kassel-Wilhelmshoehe".equals(newStadtInstance.getName())) : "The destroyed SFSB was not ignored";
    }

    @Test(groups={"integration", "lifecycle"})
    @SpecAssertions(value={@SpecAssertion(section="7.3.3", id="b")})
    public void testCreateSLSB() {
        Bean<NeueStadt> stadtBean = this.getBeans(NeueStadt.class, new Annotation[0]).iterator().next();
        assert (stadtBean != null) : "Expected a bean for stateful session bean Kassel";
        CreationalContext creationalContext = this.getCurrentManager().createCreationalContext(stadtBean);
        NeueStadt stadtInstance = (NeueStadt)stadtBean.create(creationalContext);
        assert (stadtInstance != null) : "Expected instance to be created by container";
        assert (stadtInstance instanceof NeueStadt);
        assert (stadtInstance instanceof GeschichtslosStadt);
    }

    @Test(groups={"integration", "lifecycle"})
    @SpecAssertion(section="3.10.1", id="f")
    public void testInitializerMethodsCalledWithCurrentParameterValues() {
        AlteStadt alteStadt = this.getInstanceByType(AlteStadt.class, new Annotation[0]);
        assert (alteStadt != null) : "Could not find the AlteStadt bean";
        assert (alteStadt.getAnotherPlaceOfInterest() != null);
    }

    @Test(groups={"integration", "lifecycle"})
    @SpecAssertion(section="5.5.3", id="a")
    public void testDependentObjectsDestroyed() {
        Bean<UniStadt> uniStadtBean = this.getBeans(UniStadt.class, new Annotation[0]).iterator().next();
        CreationalContext creationalContext = this.getCurrentManager().createCreationalContext(uniStadtBean);
        UniStadt marburg = (UniStadt)uniStadtBean.create(creationalContext);
        assert (marburg != null) : "Couldn't find the main SFSB";
        uniStadtBean.destroy((Object)marburg, creationalContext);
        GrossStadt frankfurt = this.getInstanceByType(GrossStadt.class, new Annotation[0]);
        assert (frankfurt.isSchlossDestroyed());
    }

    @Test(groups={"integration"})
    @SpecAssertion(section="4.2", id="bab")
    public void testDirectSubClassInheritsPostConstructOnSuperclass() throws Exception {
        OrderProcessor.postConstructCalled = false;
        assert (this.getBeans(DirectOrderProcessorLocal.class, new Annotation[0]).size() == 1);
        this.getInstanceByType(DirectOrderProcessorLocal.class, new Annotation[0]).order();
        assert (OrderProcessor.postConstructCalled);
    }

    @Test(groups={"integration"})
    @SpecAssertion(section="4.2", id="bad")
    public void testIndirectSubClassInheritsPostConstructOnSuperclass() throws Exception {
        OrderProcessor.postConstructCalled = false;
        assert (this.getBeans(OrderProcessorLocal.class, new Annotation[0]).size() == 1);
        this.getInstanceByType(OrderProcessorLocal.class, new Annotation[0]).order();
        assert (OrderProcessor.postConstructCalled);
    }

    @Test(groups={"integration"})
    @SpecAssertion(section="4.2", id="bbb")
    public void testSubClassInheritsPreDestroyOnSuperclass() throws Exception {
        OrderProcessor.preDestroyCalled = false;
        assert (this.getBeans(DirectOrderProcessorLocal.class, new Annotation[0]).size() == 1);
        Bean<DirectOrderProcessorLocal> bean = this.getBeans(DirectOrderProcessorLocal.class, new Annotation[0]).iterator().next();
        CreationalContext creationalContext = this.getCurrentManager().createCreationalContext(bean);
        DirectOrderProcessorLocal instance = (DirectOrderProcessorLocal)bean.create(creationalContext);
        bean.destroy((Object)instance, creationalContext);
        assert (OrderProcessor.preDestroyCalled);
    }

    @Test(groups={"integration"})
    @SpecAssertion(section="4.2", id="bbd")
    public void testIndirectSubClassInheritsPreDestroyOnSuperclass() throws Exception {
        OrderProcessor.preDestroyCalled = false;
        assert (this.getBeans(OrderProcessorLocal.class, new Annotation[0]).size() == 1);
        Bean<OrderProcessorLocal> bean = this.getBeans(OrderProcessorLocal.class, new Annotation[0]).iterator().next();
        CreationalContext creationalContext = this.getCurrentManager().createCreationalContext(bean);
        OrderProcessorLocal instance = (OrderProcessorLocal)bean.create(creationalContext);
        bean.destroy((Object)instance, creationalContext);
        assert (OrderProcessor.preDestroyCalled);
    }
}

