/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.implementation.producer.method.definition;

import java.lang.annotation.Annotation;
import java.util.List;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.IllegalProductException;
import javax.enterprise.inject.UnsatisfiedResolutionException;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.util.AnnotationLiteral;
import javax.enterprise.util.TypeLiteral;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.literals.AnyLiteral;
import org.jboss.cdi.tck.literals.DefaultLiteral;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.Acorn;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.Animal;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.Apple;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.AppleTree;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.BeanWithStaticProducerMethod;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.Bite;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.BlackWidow;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.Cherry;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.DaddyLongLegs;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.Deadliest;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.DeadlyAnimal;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.DeadlySpider;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.Egg;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.FunnelWeaver;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.Pollen;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.Spider;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.Tame;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.Tarantula;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.WolfSpider;
import org.jboss.cdi.tck.tests.implementation.producer.method.definition.Yummy;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class ProducerMethodDefinitionTest
extends AbstractTest {
    private static final Annotation TAME_LITERAL = new AnnotationLiteral<Tame>(){};
    private static final Annotation DEADLIEST_LITERAL = new AnnotationLiteral<Deadliest>(){};

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(ProducerMethodDefinitionTest.class)).build();
    }

    @Test(groups={"producerMethod"})
    @SpecAssertions(value={@SpecAssertion(section="3.3", id="b"), @SpecAssertion(section="5.5.4", id="a")})
    public void testStaticMethod() throws Exception {
        assert (this.getBeans(String.class, new Annotation[0]).size() == 1);
        assert (this.getInstanceByType(String.class, new Annotation[0]).equals(BeanWithStaticProducerMethod.getString()));
    }

    @Test(groups={"producerMethod"})
    @SpecAssertions(value={@SpecAssertion(section="3.3", id="aa")})
    public void testProducerOnNonBean() throws Exception {
        assert (this.getBeans(Cherry.class, new Annotation[0]).isEmpty());
    }

    @Test(groups={"producerMethod"})
    @SpecAssertions(value={@SpecAssertion(section="3.5", id="b")})
    public void testStaticDisposerMethod() throws Exception {
        assert (this.getBeans(String.class, new Annotation[0]).size() == 1);
        String aString = this.getInstanceByType(String.class, new Annotation[0]);
        Bean<String> stringBean = this.getBeans(String.class, new Annotation[0]).iterator().next();
        CreationalContext creationalContext = this.getCurrentManager().createCreationalContext(stringBean);
        stringBean.destroy((Object)aString, creationalContext);
        assert (BeanWithStaticProducerMethod.stringDestroyed);
    }

    @Test(groups={"producerMethod"})
    @SpecAssertion(section="3.3", id="ga")
    public void testParameterizedReturnType() throws Exception {
        assert (this.getBeans(new TypeLiteral<FunnelWeaver<Spider>>(){}, new Annotation[0]).size() == 1);
    }

    @Test(groups={"producerMethod"})
    @SpecAssertions(value={@SpecAssertion(section="3.3", id="c"), @SpecAssertion(section="3.3.2", id="a"), @SpecAssertion(section="2.3.1", id="a0"), @SpecAssertion(section="2.3.1", id="aa")})
    public void testDefaultBindingType() throws Exception {
        assert (this.getCurrentManager().getBeans(Tarantula.class, new Annotation[0]).size() == 1);
        assert (((Bean)this.getCurrentManager().getBeans(Tarantula.class, new Annotation[0]).iterator().next()).getQualifiers().size() == 2);
        assert (((Bean)this.getCurrentManager().getBeans(Tarantula.class, new Annotation[0]).iterator().next()).getQualifiers().contains((Object)new DefaultLiteral()));
        assert (((Bean)this.getCurrentManager().getBeans(Tarantula.class, new Annotation[0]).iterator().next()).getQualifiers().contains(AnyLiteral.INSTANCE));
    }

    @Test(groups={"producerMethod"})
    @SpecAssertions(value={@SpecAssertion(section="3.3.1", id="c"), @SpecAssertion(section="2.2", id="l")})
    public void testApiTypeForClassReturn() throws Exception {
        assert (this.getBeans(Tarantula.class, new Annotation[0]).size() == 1);
        Bean<Tarantula> tarantula = this.getBeans(Tarantula.class, new Annotation[0]).iterator().next();
        assert (tarantula.getTypes().size() == 6);
        assert (tarantula.getTypes().contains(Tarantula.class));
        assert (tarantula.getTypes().contains(DeadlySpider.class));
        assert (tarantula.getTypes().contains(Spider.class));
        assert (tarantula.getTypes().contains(Animal.class));
        assert (tarantula.getTypes().contains(DeadlyAnimal.class));
        assert (tarantula.getTypes().contains(Object.class));
    }

    @Test(groups={"producerMethod"})
    @SpecAssertion(section="3.3.1", id="a")
    public void testApiTypeForInterfaceReturn() throws Exception {
        assert (this.getBeans(Bite.class, new Annotation[0]).size() == 1);
        Bean<Bite> animal = this.getBeans(Bite.class, new Annotation[0]).iterator().next();
        assert (animal.getTypes().size() == 2);
        assert (animal.getTypes().contains(Bite.class));
        assert (animal.getTypes().contains(Object.class));
    }

    @Test(groups={"producerMethod"})
    @SpecAssertion(section="3.3.1", id="ba")
    public void testApiTypeForPrimitiveReturn() throws Exception {
        assert (this.getBeans(Integer.class, new Annotation[0]).size() == 1);
        Bean<Integer> integer = this.getBeans(Integer.class, new Annotation[0]).iterator().next();
        assert (integer.getTypes().size() == 2);
        assert (integer.getTypes().contains(Integer.TYPE));
        assert (integer.getTypes().contains(Object.class));
    }

    @Test(groups={"producerMethod"})
    @SpecAssertions(value={@SpecAssertion(section="3.3.1", id="bb"), @SpecAssertion(section="2.2.1", id="i")})
    public void testApiTypeForArrayTypeReturn() throws Exception {
        assert (this.getBeans(Spider[].class, new Annotation[0]).size() == 1);
        Bean<Spider[]> spiders = this.getBeans(Spider[].class, new Annotation[0]).iterator().next();
        assert (spiders.getTypes().size() == 2);
        assert (spiders.getTypes().contains(Spider[].class));
        assert (spiders.getTypes().contains(Object.class));
    }

    @Test(groups={"producerMethod"})
    @SpecAssertions(value={@SpecAssertion(section="3.3.2", id="be"), @SpecAssertion(section="3.3", id="k"), @SpecAssertion(section="2.3.3", id="b")})
    public void testBindingType() throws Exception {
        assert (this.getBeans(Tarantula.class, TAME_LITERAL).size() == 1);
        Bean<Tarantula> tarantula = this.getBeans(Tarantula.class, TAME_LITERAL).iterator().next();
        assert (tarantula.getQualifiers().size() == 2);
        assert (tarantula.getQualifiers().contains(TAME_LITERAL));
    }

    @Test(groups={"producerMethod"})
    @SpecAssertions(value={@SpecAssertion(section="3.3.2", id="ba"), @SpecAssertion(section="3.3", id="k")})
    public void testScopeType() throws Exception {
        assert (this.getBeans(DaddyLongLegs.class, TAME_LITERAL).size() == 1);
        Bean<DaddyLongLegs> daddyLongLegs = this.getBeans(DaddyLongLegs.class, TAME_LITERAL).iterator().next();
        assert (daddyLongLegs.getScope().equals(RequestScoped.class));
    }

    @Test(groups={"producerMethod"})
    @SpecAssertions(value={@SpecAssertion(section="3.3.2", id="bb"), @SpecAssertion(section="2.5.1", id="b")})
    public void testNamedMethod() throws Exception {
        assert (this.getBeans(BlackWidow.class, TAME_LITERAL).size() == 1);
        Bean<BlackWidow> blackWidowSpider = this.getBeans(BlackWidow.class, TAME_LITERAL).iterator().next();
        assert (blackWidowSpider.getName().equals("blackWidow"));
    }

    @Test(groups={"producerMethod"})
    @SpecAssertions(value={@SpecAssertion(section="3.3.2", id="bb"), @SpecAssertion(section="2.5.2", id="b"), @SpecAssertion(section="2.5.1", id="d"), @SpecAssertion(section="3.3.8", id="a")})
    public void testDefaultNamedMethod() throws Exception {
        assert (this.getBeans(DaddyLongLegs.class, TAME_LITERAL).size() == 1);
        Bean<DaddyLongLegs> daddyLongLegsSpider = this.getBeans(DaddyLongLegs.class, TAME_LITERAL).iterator().next();
        assert (daddyLongLegsSpider.getName().equals("produceDaddyLongLegs"));
    }

    @Test(groups={"producerMethod"})
    @SpecAssertions(value={@SpecAssertion(section="2.7.2", id="b"), @SpecAssertion(section="3.3.2", id="ba"), @SpecAssertion(section="2.4.4", id="c"), @SpecAssertion(section="3.3.2", id="bd")})
    public void testStereotypeSpecifiesScope() throws Exception {
        assert (this.getBeans(WolfSpider.class, TAME_LITERAL).size() == 1);
        Bean<WolfSpider> wolfSpider = this.getBeans(WolfSpider.class, TAME_LITERAL).iterator().next();
        assert (wolfSpider.getScope().equals(RequestScoped.class));
    }

    @Test(expectedExceptions={UnsatisfiedResolutionException.class})
    @SpecAssertions(value={@SpecAssertion(section="4.2", id="da"), @SpecAssertion(section="4.3", id="cb")})
    public void testNonStaticProducerMethodNotInheritedBySpecializingSubclass() {
        assert (this.getBeans(Egg.class, new Annotation[]{new AnnotationLiteral<Yummy>(){}}).size() == 0);
        this.getInstanceByType(Egg.class, new Annotation[]{new AnnotationLiteral<Yummy>(){}});
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="4.2", id="da"), @SpecAssertion(section="4.2", id="dg")})
    public void testNonStaticProducerMethodNotInherited() {
        assert (this.getBeans(Apple.class, new Annotation[]{new AnnotationLiteral<Yummy>(){}}).size() == 1);
        assert (this.getInstanceByType(Apple.class, new Annotation[]{new AnnotationLiteral<Yummy>(){}}).getTree().getClass().equals(AppleTree.class));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="2.3.5", id="a"), @SpecAssertion(section="3.3.2", id="i"), @SpecAssertion(section="3.3.2", id="h")})
    public void testBindingTypesAppliedToProducerMethodParameters() {
        Bean<Tarantula> tarantula = this.getBeans(Tarantula.class, DEADLIEST_LITERAL).iterator().next();
        CreationalContext creationalContext = this.getCurrentManager().createCreationalContext(tarantula);
        Tarantula instance = (Tarantula)tarantula.create(creationalContext);
        assert (instance.getDeathsCaused() == 1);
    }

    @Test
    @SpecAssertion(section="3.3", id="e")
    public void testDependentProducerReturnsNullValue() {
        assert (this.getInstanceByType(Acorn.class, new Annotation[0]) == null);
    }

    @Test(expectedExceptions={IllegalProductException.class})
    @SpecAssertion(section="3.3", id="f")
    public void testNonDependentProducerReturnsNullValue() {
        this.getInstanceByType(Pollen.class, new Annotation[]{new AnnotationLiteral<Yummy>(){}}).ping();
        assert (false);
    }

    @Test
    @SpecAssertion(section="3.3", id="iaa")
    public void testTypeVariableReturnType() {
        assert (this.getBeans(new TypeLiteral<List<Spider>>(){}, new Annotation[0]).size() == 1);
    }
}

