/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.implementation.simple.definition;

import java.lang.annotation.Annotation;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.implementation.simple.definition.Antelope_NotBean;
import org.jboss.cdi.tck.tests.implementation.simple.definition.Car;
import org.jboss.cdi.tck.tests.implementation.simple.definition.Cow_NotBean;
import org.jboss.cdi.tck.tests.implementation.simple.definition.Donkey;
import org.jboss.cdi.tck.tests.implementation.simple.definition.OuterClass;
import org.jboss.cdi.tck.tests.implementation.simple.definition.Sheep;
import org.jboss.cdi.tck.tests.implementation.simple.definition.SimpleExtension;
import org.jboss.cdi.tck.tests.implementation.simple.definition.Tiger;
import org.jboss.cdi.tck.tests.implementation.simple.definition.Turkey;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class SimpleBeanDefinitionTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(SimpleBeanDefinitionTest.class)).build();
    }

    @Test
    @SpecAssertion(section="3.1.1", id="ca")
    public void testAbstractClassDeclaredInJavaNotDiscovered() {
        assert (this.getBeans(Cow_NotBean.class, new Annotation[0]).size() == 0);
    }

    @Test(groups={"innerClass"})
    @SpecAssertions(value={@SpecAssertion(section="3.1.1", id="ba")})
    public void testStaticInnerClassDeclaredInJavaAllowed() {
        assert (this.getBeans(OuterClass.StaticInnerClass.class, new Annotation[0]).size() == 1);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="3.1.1", id="b")})
    public void testNonStaticInnerClassDeclaredInJavaNotDiscovered() {
        assert (this.getBeans(OuterClass.InnerClass_NotBean.class, new Annotation[0]).size() == 0);
    }

    @Test
    @SpecAssertion(section="3.1.1", id="cb")
    public void testInterfaceNotDiscoveredAsSimpleBean() {
        assert (this.getBeans(Car.class, new Annotation[0]).size() == 0);
    }

    @Test
    @SpecAssertion(section="3.1.1", id="g")
    public void testExtensionNotDiscoveredAsSimpleBean() {
        assert (this.getBeans(SimpleExtension.class, new Annotation[0]).size() == 0);
    }

    @Test
    @SpecAssertion(section="3.1.1", id="p")
    public void testSimpleBeanOnlyIfConstructorParameterless() {
        assert (this.getBeans(Antelope_NotBean.class, new Annotation[0]).isEmpty());
        assert (!this.getBeans(Donkey.class, new Annotation[0]).isEmpty());
    }

    @Test
    @SpecAssertion(section="3.1.1", id="q")
    public void testSimpleBeanOnlyIfConstructorIsInitializer() {
        assert (this.getBeans(Antelope_NotBean.class, new Annotation[0]).isEmpty());
        assert (!this.getBeans(Sheep.class, new Annotation[0]).isEmpty());
    }

    @Test
    @SpecAssertion(section="3.8.1", id="aa")
    public void testInitializerAnnotatedConstructor() throws Exception {
        Sheep.constructedCorrectly = false;
        this.getInstanceByType(Sheep.class, new Annotation[0]);
        assert (Sheep.constructedCorrectly);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="3.8.1", id="ba"), @SpecAssertion(section="3.1.3", id="a"), @SpecAssertion(section="3.8", id="a"), @SpecAssertion(section="5.5.1", id="ba")})
    public void testEmptyConstructorUsed() {
        Donkey.constructedCorrectly = false;
        this.getInstanceByType(Donkey.class, new Annotation[0]);
        assert (Donkey.constructedCorrectly);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="3.8.1", id="aa"), @SpecAssertion(section="5.5.1", id="aa")})
    public void testInitializerAnnotatedConstructorUsedOverEmptyConstuctor() throws Exception {
        this.getInstanceByType(Turkey.class, new Annotation[0]);
        assert (Turkey.constructedCorrectly);
    }

    @Test
    @SpecAssertion(section="3.1", id="fa")
    public void testDependentScopedBeanCanHavePublicField() throws Exception {
        assert (this.getInstanceByType(Tiger.class, (Annotation[])new Annotation[0]).name.equals("pete"));
    }
}

