/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.implementation.simple.resource.ejb;

import java.lang.annotation.Annotation;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.util.AnnotationLiteral;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.implementation.simple.resource.ejb.AnotherInterface;
import org.jboss.cdi.tck.tests.implementation.simple.resource.ejb.BeanRemote;
import org.jboss.cdi.tck.tests.implementation.simple.resource.ejb.Lazy;
import org.jboss.cdi.tck.tests.implementation.simple.resource.ejb.ManagedBean;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class EjbInjectionTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(EjbInjectionTest.class)).withBeansXml("beans.xml")).build();
    }

    @Test(groups={"integration", "lifecycle"})
    @SpecAssertions(value={@SpecAssertion(section="3.6.1", id="ee"), @SpecAssertion(section="7.3.6", id="ld"), @SpecAssertion(section="7.3.6", id="mg")})
    public void testInjectionOfEjbs() {
        Bean<ManagedBean> managedBean = this.getBeans(ManagedBean.class, new Annotation[0]).iterator().next();
        CreationalContext creationalContext = this.getCurrentManager().createCreationalContext(managedBean);
        ManagedBean instance = (ManagedBean)managedBean.create(creationalContext);
        assert (instance.getMyEjb() != null) : "EJB reference was not produced and injected into bean";
        assert (instance.getMyEjb().knockKnock().equals("We're home"));
    }

    @Test(groups={"integration", "lifecycle"})
    @SpecAssertions(value={@SpecAssertion(section="7.3.6", id="mh")})
    public void testPassivationOfEjbs() throws Exception {
        Bean<ManagedBean> managedBean = this.getBeans(ManagedBean.class, new Annotation[0]).iterator().next();
        CreationalContext creationalContext = this.getCurrentManager().createCreationalContext(managedBean);
        ManagedBean instance = (ManagedBean)managedBean.create(creationalContext);
        instance = (ManagedBean)this.deserialize(this.serialize(instance));
        assert (instance.getMyEjb() != null) : "EJB reference was not produced and injected into bean";
        assert (instance.getMyEjb().knockKnock().equals("We're home"));
    }

    @Test(groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="3.5.2", id="ad")})
    public void testResourceBeanTypes() {
        Bean<BeanRemote> beanRemote = this.getBeans(BeanRemote.class, new Annotation[]{new AnnotationLiteral<Lazy>(){}}).iterator().next();
        assert (beanRemote.getTypes().size() == 3);
        assert (this.rawTypeSetMatches(beanRemote.getTypes(), BeanRemote.class, Object.class, AnotherInterface.class));
    }
}

