/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.inheritance.specialization.enterprise;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Named;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.inheritance.specialization.enterprise.FarmerLocal;
import org.jboss.cdi.tck.tests.inheritance.specialization.enterprise.Landowner;
import org.jboss.cdi.tck.tests.inheritance.specialization.enterprise.Lazy;
import org.jboss.cdi.tck.tests.inheritance.specialization.enterprise.LazyFarmerLocal;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class EnterpriseBeanSpecializationTest
extends AbstractTest {
    private static Annotation LANDOWNER_LITERAL = new AnnotationLiteral<Landowner>(){};

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(EnterpriseBeanSpecializationTest.class)).build();
    }

    @Test(groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="4.3.1", id="j"), @SpecAssertion(section="3.2.4", id="aa")})
    public void testSpecializingBeanHasBindingsOfSpecializedAndSpecializingBean() {
        assert (this.getCurrentManager().getBeans(LazyFarmerLocal.class, new Annotation[]{LANDOWNER_LITERAL}).size() == 1);
        Bean<LazyFarmerLocal> bean = this.getBeans(LazyFarmerLocal.class, LANDOWNER_LITERAL).iterator().next();
        assert (((Bean)this.getCurrentManager().getBeans(LazyFarmerLocal.class, new Annotation[]{LANDOWNER_LITERAL}).iterator().next()).getTypes().contains(FarmerLocal.class));
        assert (((Bean)this.getCurrentManager().getBeans(LazyFarmerLocal.class, new Annotation[]{LANDOWNER_LITERAL}).iterator().next()).getQualifiers().size() == 4);
        assert (this.annotationSetMatches((Set<? extends Annotation>)((Bean)this.getCurrentManager().getBeans(LazyFarmerLocal.class, new Annotation[]{LANDOWNER_LITERAL}).iterator().next()).getQualifiers(), Landowner.class, Lazy.class, Any.class, Named.class));
    }

    @Test(groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="4.3.1", id="k")})
    public void testSpecializingBeanHasNameOfSpecializedBean() {
        assert (this.getBeans(LazyFarmerLocal.class, LANDOWNER_LITERAL).size() == 1);
        assert (this.getBeans(LazyFarmerLocal.class, LANDOWNER_LITERAL).iterator().next().getName().equals("farmer"));
    }
}

