/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.inheritance.specialization.producer.method;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Named;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.inheritance.specialization.producer.method.Expensive;
import org.jboss.cdi.tck.tests.inheritance.specialization.producer.method.Necklace;
import org.jboss.cdi.tck.tests.inheritance.specialization.producer.method.Product;
import org.jboss.cdi.tck.tests.inheritance.specialization.producer.method.Sparkly;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class ProducerMethodSpecializationTest
extends AbstractTest {
    private static Annotation EXPENSIVE_LITERAL = new AnnotationLiteral<Expensive>(){};
    private static Annotation SPARKLY_LITERAL = new AnnotationLiteral<Sparkly>(){};

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(ProducerMethodSpecializationTest.class)).withBeansXml("beans.xml")).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.5.4", id="c"), @SpecAssertion(section="3.3.3", id="aa")})
    public void testSpecializingBeanHasBindingsOfSpecializedAndSpecializingBean() {
        assert (this.getCurrentManager().getBeans(Necklace.class, new Annotation[]{EXPENSIVE_LITERAL, SPARKLY_LITERAL}).size() == 1);
        assert (((Bean)this.getCurrentManager().getBeans(Necklace.class, new Annotation[]{EXPENSIVE_LITERAL, SPARKLY_LITERAL}).iterator().next()).getQualifiers().size() == 4);
        assert (this.annotationSetMatches((Set<? extends Annotation>)((Bean)this.getCurrentManager().getBeans(Necklace.class, new Annotation[]{EXPENSIVE_LITERAL, SPARKLY_LITERAL}).iterator().next()).getQualifiers(), Expensive.class, Sparkly.class, Any.class, Named.class));
        assert (this.getBeans(Necklace.class, SPARKLY_LITERAL).size() == 1);
        assert (this.getBeans(Necklace.class, SPARKLY_LITERAL).iterator().next().getName().equals("expensiveGift"));
        Product product = this.getInstanceByType(Product.class, EXPENSIVE_LITERAL, SPARKLY_LITERAL);
        assert (product instanceof Necklace);
    }
}

