/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.inheritance.specialization.simple;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.UnsatisfiedResolutionException;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Named;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.inheritance.specialization.simple.Farmer;
import org.jboss.cdi.tck.tests.inheritance.specialization.simple.Landowner;
import org.jboss.cdi.tck.tests.inheritance.specialization.simple.Lazy;
import org.jboss.cdi.tck.tests.inheritance.specialization.simple.LazyFarmer;
import org.jboss.cdi.tck.tests.inheritance.specialization.simple.Waste;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class SimpleBeanSpecializationTest
extends AbstractTest {
    private static Annotation LANDOWNER_LITERAL = new AnnotationLiteral<Landowner>(){};

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(SimpleBeanSpecializationTest.class)).withBeansXml("beans.xml")).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="4.3.1", id="ia"), @SpecAssertion(section="4.3.1", id="ib"), @SpecAssertion(section="4.3.1", id="j"), @SpecAssertion(section="3.1.4", id="aa")})
    public void testSpecializingBeanHasQualifiersOfSpecializedAndSpecializingBean() {
        assert (this.getBeans(LazyFarmer.class, LANDOWNER_LITERAL).size() == 1);
        Bean<LazyFarmer> bean = this.getBeans(LazyFarmer.class, LANDOWNER_LITERAL).iterator().next();
        assert (bean.getTypes().contains(Farmer.class));
        assert (bean.getQualifiers().size() == 4);
        assert (this.annotationSetMatches((Set<? extends Annotation>)bean.getQualifiers(), Landowner.class, Lazy.class, Any.class, Named.class));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="4.3.1", id="k"), @SpecAssertion(section="3.1.4", id="ab")})
    public void testSpecializingBeanHasNameOfSpecializedBean() {
        assert (this.getBeans(LazyFarmer.class, LANDOWNER_LITERAL).size() == 1);
        assert ("farmer".equals(this.getBeans(LazyFarmer.class, LANDOWNER_LITERAL).iterator().next().getName()));
    }

    @Test(expectedExceptions={UnsatisfiedResolutionException.class})
    @SpecAssertions(value={@SpecAssertion(section="4.3", id="cb")})
    public void testProducerMethodOnSpecializedBeanNotCalled() {
        assert (this.getBeans(Waste.class, new Annotation[0]).size() == 0);
        this.getInstanceByType(Waste.class, new Annotation[0]);
    }
}

