/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.interceptors.definition.multipleBindings;

import java.lang.annotation.Annotation;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.interceptors.definition.multipleBindings.FastAndDeadlyMissile;
import org.jboss.cdi.tck.tests.interceptors.definition.multipleBindings.GuidedMissile;
import org.jboss.cdi.tck.tests.interceptors.definition.multipleBindings.LockInterceptor;
import org.jboss.cdi.tck.tests.interceptors.definition.multipleBindings.Missile;
import org.jboss.cdi.tck.tests.interceptors.definition.multipleBindings.MissileInterceptor;
import org.jboss.cdi.tck.tests.interceptors.definition.multipleBindings.SlowMissile;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class MultipleInterceptorBindingsTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(MultipleInterceptorBindingsTest.class)).withBeansXml("beans.xml")).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="9.5.1", id="a"), @SpecAssertion(section="9.5", id="ca"), @SpecAssertion(section="9.2", id="ab"), @SpecAssertion(section="9.3", id="ba")})
    public void testInterceptorAppliedToBeanWithAllBindings() {
        MissileInterceptor.intercepted = false;
        Missile missile = this.getInstanceByType(FastAndDeadlyMissile.class, new Annotation[0]);
        missile.fire();
        assert (MissileInterceptor.intercepted);
    }

    @Test
    @SpecAssertion(section="9.5.1", id="b")
    public void testInterceptorNotAppliedToBeanWithSomeBindings() {
        MissileInterceptor.intercepted = false;
        Missile missile = this.getInstanceByType(SlowMissile.class, new Annotation[0]);
        missile.fire();
        assert (!MissileInterceptor.intercepted);
    }

    @Test
    @SpecAssertion(section="9.3", id="bb")
    public void testMultipleInterceptorsOnMethod() {
        LockInterceptor.intercepted = false;
        GuidedMissile bullet = this.getInstanceByType(GuidedMissile.class, new Annotation[0]);
        bullet.fire();
        assert (!LockInterceptor.intercepted);
        bullet.lockAndFire();
        assert (LockInterceptor.intercepted);
    }
}

