/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.interceptors.invocation;

import java.lang.annotation.Annotation;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.interceptors.invocation.Missile;
import org.jboss.cdi.tck.tests.interceptors.invocation.MissileInterceptor;
import org.jboss.cdi.tck.tests.interceptors.invocation.MissileObserver;
import org.jboss.cdi.tck.tests.interceptors.invocation.Rye;
import org.jboss.cdi.tck.tests.interceptors.invocation.Wheat;
import org.jboss.cdi.tck.tests.interceptors.invocation.WheatProducer;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.beans10.BeansDescriptor;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class InterceptorInvocationTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(InterceptorInvocationTest.class)).withBeansXml((BeansDescriptor)((BeansDescriptor)Descriptors.create(BeansDescriptor.class)).createInterceptors().clazz(new String[]{MissileInterceptor.class.getName()}).up())).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="7.2", id="a"), @SpecAssertion(section="9.2", id="a"), @SpecAssertion(section="12.4", id="kb")})
    public void testManagedBeanIsIntercepted() {
        MissileInterceptor.reset();
        Missile missile = this.getInstanceByType(Missile.class, new Annotation[0]);
        missile.fire();
        assert (MissileInterceptor.methodIntercepted);
        assert (missile.getWarhead() != null);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="7.2", id="a1"), @SpecAssertion(section="3.10", id="f")})
    public void testInitializerMethodsNotIntercepted() {
        MissileInterceptor.reset();
        Missile missile = this.getInstanceByType(Missile.class, new Annotation[0]);
        assert (!MissileInterceptor.methodIntercepted);
        assert (missile.initCalled());
        assert (MissileInterceptor.methodIntercepted);
    }

    @Test
    @SpecAssertion(section="7.2", id="ia")
    public void testProducerMethodsAreIntercepted() {
        MissileInterceptor.reset();
        this.getInstanceByType(Wheat.class, new Annotation[0]);
        assert (MissileInterceptor.methodIntercepted);
    }

    @Test
    @SpecAssertion(section="7.2", id="ic")
    public void testDisposerMethodsAreIntercepted() {
        MissileInterceptor.reset();
        Bean<Wheat> bean = this.getBeans(Wheat.class, new Annotation[0]).iterator().next();
        CreationalContext creationalContext = this.getCurrentManager().createCreationalContext(bean);
        Wheat instance = this.getInstanceByType(Wheat.class, new Annotation[0]);
        MissileInterceptor.methodIntercepted = false;
        bean.destroy((Object)instance, creationalContext);
        assert (WheatProducer.destroyed);
        assert (MissileInterceptor.methodIntercepted);
    }

    @Test
    @SpecAssertion(section="7.2", id="ie")
    public void testObserverMethodsAreIntercepted() {
        MissileInterceptor.reset();
        this.getCurrentManager().fireEvent((Object)new Missile(), new Annotation[0]);
        assert (MissileObserver.observed);
        assert (MissileInterceptor.methodIntercepted);
    }

    @Test
    @SpecAssertion(section="7.2", id="j")
    public void testLifecycleCallbacksAreIntercepted() {
        MissileInterceptor.reset();
        this.getInstanceByType(Rye.class, new Annotation[0]);
        assert (!MissileInterceptor.methodIntercepted);
        assert (MissileInterceptor.lifecycleCallbackIntercepted);
    }
}

