/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.lookup.dynamic.builtin;

import java.lang.annotation.Annotation;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.util.TypeLiteral;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.lookup.dynamic.builtin.Cow;
import org.jboss.cdi.tck.tests.lookup.dynamic.builtin.Farm;
import org.jboss.cdi.tck.tests.lookup.dynamic.builtin.Field;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class BuiltinInstanceTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(BuiltinInstanceTest.class)).build();
    }

    @Test
    @SpecAssertion(section="5.6.2", id="d")
    public void testScopeOfBuiltinInstance() {
        Bean<Instance<Cow>> bean = this.getBeans(new TypeLiteral<Instance<Cow>>(){}, new Annotation[0]).iterator().next();
        assert (Dependent.class.equals((Object)bean.getScope()));
    }

    @Test
    @SpecAssertion(section="5.6.2", id="e")
    public void testNameOfBuiltinInstance() {
        Bean<Instance<Cow>> bean = this.getBeans(new TypeLiteral<Instance<Cow>>(){}, new Annotation[0]).iterator().next();
        assert (bean.getName() == null);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.6.2", id="a"), @SpecAssertion(section="5.6.2", id="f")})
    public void testInstanceProvidedForEveryLegalBeanType() {
        Farm farm = this.getInstanceByType(Farm.class, new Annotation[0]);
        assert (farm.getAnimal() != null);
        assert (farm.getAbstractAnimal() != null);
        assert (farm.getCow() != null);
    }

    @Test
    @SpecAssertion(section="5.6.2", id="g")
    public void testInstanceIsPassivationCapable() throws Exception {
        Field field = this.getInstanceByType(Field.class, new Annotation[0]);
        Object object = this.deserialize(this.serialize(field));
        assert (field.getInstance().get() instanceof Cow);
        assert (object instanceof Field);
        Field field2 = (Field)object;
        assert (field2.getInstance().get() instanceof Cow);
    }
}

