/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.lookup.manager.web;

import com.gargoylesoftware.htmlunit.TextPage;
import com.gargoylesoftware.htmlunit.WebClient;
import java.net.URL;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.EnterpriseArchiveBuilder;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.lookup.manager.web.AlphaServlet;
import org.jboss.cdi.tck.tests.lookup.manager.web.Bar;
import org.jboss.cdi.tck.tests.lookup.manager.web.BravoServlet;
import org.jboss.cdi.tck.tests.lookup.manager.web.Foo;
import org.jboss.cdi.tck.tests.lookup.manager.web.VerifyingListener;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.application6.ApplicationDescriptor;
import org.jboss.shrinkwrap.descriptor.api.application6.ModuleType;
import org.jboss.shrinkwrap.descriptor.api.beans10.BeansDescriptor;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"javaee-full"})
@SpecVersion(spec="cdi", version="20091101")
public class BeanManagerServletContextEarTest
extends AbstractTest {
    @ArquillianResource(value=AlphaServlet.class)
    private URL urlAlpha;
    @ArquillianResource(value=BravoServlet.class)
    private URL urlBravo;

    @Deployment(testable=false)
    public static EnterpriseArchive createTestArchive() {
        EnterpriseArchive enterpriseArchive = (EnterpriseArchive)((EnterpriseArchiveBuilder)new EnterpriseArchiveBuilder().withTestClass(BeanManagerServletContextEarTest.class)).build();
        StringAsset applicationXml = new StringAsset(((ApplicationDescriptor)((ModuleType)((ApplicationDescriptor)((ModuleType)((ApplicationDescriptor)Descriptors.create(ApplicationDescriptor.class)).applicationName("Test").createModule().getOrCreateWeb().webUri("alpha.war").contextRoot("/alpha").up()).up()).createModule().getOrCreateWeb().webUri("bravo.war").contextRoot("/bravo").up()).up()).exportAsString());
        enterpriseArchive.setApplicationXML((Asset)applicationXml);
        WebArchive fooArchive = (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().notTestArchive()).withName("alpha.war")).withClasses(Foo.class, Bar.class, AlphaServlet.class, VerifyingListener.class)).withDefaultEjbModuleDependency().build();
        enterpriseArchive.addAsModule((Archive)fooArchive);
        WebArchive barArchive = (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().notTestArchive()).withName("bravo.war")).withBeansXml((BeansDescriptor)((BeansDescriptor)Descriptors.create(BeansDescriptor.class)).createAlternatives().clazz(new String[]{Bar.class.getName()}).up())).withClasses(Foo.class, Bar.class, BravoServlet.class, VerifyingListener.class)).withDefaultEjbModuleDependency().build();
        enterpriseArchive.addAsModule((Archive)barArchive);
        return enterpriseArchive;
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="11.3.1", id="e")})
    public void testCorrectBeanManagerAvailable() throws Exception {
        WebClient client = new WebClient();
        TextPage page1 = (TextPage)client.getPage(this.urlAlpha);
        Assert.assertEquals((String)page1.getContent(), (String)"foo,foo");
        TextPage page2 = (TextPage)client.getPage(this.urlBravo);
        Assert.assertEquals((String)page2.getContent(), (String)"bar,bar");
    }
}

