/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.lookup.typesafe.resolution;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.util.AnnotationLiteral;
import javax.enterprise.util.TypeLiteral;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.literals.AnyLiteral;
import org.jboss.cdi.tck.literals.DefaultLiteral;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.African;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.Animal;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.Australian;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.Bird;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.Canary;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.Cat;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.ChunkyLiteral;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.Cod;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.CrabSpider;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.DaddyLongLegs;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.DomesticCat;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.Dove;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.Emu;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.European;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.ExpensiveLiteral;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.Farmer;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.FishILike;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.FlightlessBird;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.Haddock;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.Halibut;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.Lion;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.Max;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.Min;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.NumberProducer;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.Parrot;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.RoundWhitefish;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.Salmon;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.ScottishFish;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.ScottishFishFarmer;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.SeaBass;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.Sole;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.Spider;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.Tame;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.Tuna;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.Whitefish;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.Wild;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class ResolutionByTypeTest
extends AbstractTest {
    private static final TypeLiteral<FlightlessBird<Australian>> AUSTRALIAN_FLIGHTLESS_BIRD = new TypeLiteral<FlightlessBird<Australian>>(){};
    private static final TypeLiteral<FlightlessBird<European>> EUROPEAN_FLIGHTLESS_BIRD = new TypeLiteral<FlightlessBird<European>>(){};
    private static final TypeLiteral<Cat<European>> EUROPEAN_CAT = new TypeLiteral<Cat<European>>(){};
    private static final TypeLiteral<Cat<African>> AFRICAN_CAT = new TypeLiteral<Cat<African>>(){};
    private static final Annotation TAME = new AnnotationLiteral<Tame>(){};
    private static final Annotation WILD = new AnnotationLiteral<Wild>(){};

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(ResolutionByTypeTest.class)).build();
    }

    @Test(groups={"resolution"})
    @SpecAssertion(section="5.2", id="lb")
    public void testDefaultBindingTypeAssumed() throws Exception {
        Set<Bean<Tuna>> possibleTargets = this.getBeans(Tuna.class, new Annotation[0]);
        assert (possibleTargets.size() == 1);
        assert (possibleTargets.iterator().next().getTypes().contains(Tuna.class));
    }

    @Test(groups={"resolution"})
    @SpecAssertion(section="5.2", id="hc")
    public void testResolveByType() throws Exception {
        assert (this.getBeans(Tuna.class, new Annotation[]{new DefaultLiteral()}).size() == 1);
        assert (this.getBeans(Tuna.class, new Annotation[0]).size() == 1);
        Set<Bean<Animal>> beans = this.getBeans(Animal.class, new Annotation[]{new AnnotationLiteral<FishILike>(){}});
        assert (beans.size() == 3);
        ArrayList<Class<Haddock>> classes = new ArrayList<Class<Haddock>>();
        for (Bean<Animal> bean : beans) {
            if (bean.getTypes().contains(Salmon.class)) {
                classes.add(Salmon.class);
                continue;
            }
            if (bean.getTypes().contains(SeaBass.class)) {
                classes.add(SeaBass.class);
                continue;
            }
            if (!bean.getTypes().contains(Haddock.class)) continue;
            classes.add(Haddock.class);
        }
        assert (classes.contains(Salmon.class));
        assert (classes.contains(SeaBass.class));
        assert (classes.contains(Haddock.class));
    }

    @Test(groups={"injection"})
    @SpecAssertions(value={@SpecAssertion(section="2.3.4", id="b"), @SpecAssertion(section="5.2", id="lc"), @SpecAssertion(section="2.3.3", id="d"), @SpecAssertion(section="5.2", id="la"), @SpecAssertion(section="5.2.6", id="a"), @SpecAssertion(section="5.2.6", id="d")})
    public void testAllQualifiersSpecifiedForResolutionMustAppearOnBean() {
        assert (this.getBeans(Animal.class, new Annotation[]{new ChunkyLiteral(), new AnnotationLiteral<Whitefish>(){}}).size() == 1);
        assert (this.getBeans(Animal.class, new Annotation[]{new ChunkyLiteral(), new AnnotationLiteral<Whitefish>(){}}).iterator().next().getTypes().contains(Cod.class));
        assert (this.getBeans(ScottishFish.class, new Annotation[]{new AnnotationLiteral<Whitefish>(){}}).size() == 2);
        ArrayList<Class> classes = new ArrayList<Class>();
        for (Bean<ScottishFish> bean : this.getBeans(ScottishFish.class, new Annotation[]{new AnnotationLiteral<Whitefish>(){}})) {
            if (bean.getTypes().contains(Cod.class)) {
                classes.add(Cod.class);
                continue;
            }
            if (!bean.getTypes().contains(Sole.class)) continue;
            classes.add(Sole.class);
        }
        assert (classes.contains(Cod.class));
        assert (classes.contains(Sole.class));
    }

    @Test(groups={"resolution"})
    @SpecAssertions(value={@SpecAssertion(section="5.2", id="ka")})
    public void testResolveByTypeWithTypeParameter() throws Exception {
        assert (this.getBeans(new TypeLiteral<Farmer<ScottishFish>>(){}, new Annotation[0]).size() == 1);
        assert (this.getBeans(new TypeLiteral<Farmer<ScottishFish>>(){}, new Annotation[0]).iterator().next().getTypes().contains(ScottishFishFarmer.class));
    }

    @Test(groups={"resolution", "producerMethod"})
    @SpecAssertions(value={@SpecAssertion(section="5.2", id="j"), @SpecAssertion(section="2.2.1", id="i")})
    public void testResolveByTypeWithArray() throws Exception {
        assert (this.getBeans(Spider[].class, new Annotation[0]).size() == 1);
    }

    @Test(groups={"resolution"})
    @SpecAssertions(value={@SpecAssertion(section="5.2", id="i"), @SpecAssertion(section="5.2.4", id="aa"), @SpecAssertion(section="5.2.4", id="ab"), @SpecAssertion(section="5.2.6", id="b"), @SpecAssertion(section="5.2.6", id="c")})
    public void testResolveByTypeWithPrimitives() {
        assert (this.getBeans(Double.class, new Annotation[]{AnyLiteral.INSTANCE}).size() == 2);
        assert (this.getBeans(Double.TYPE, new Annotation[]{AnyLiteral.INSTANCE}).size() == 2);
        Double min = this.getInstanceByType(Double.class, new Annotation[]{new AnnotationLiteral<Min>(){}});
        double max = this.getInstanceByType(Double.TYPE, new Annotation[]{new AnnotationLiteral<Max>(){}});
        assert (min.equals(0.0));
        assert (NumberProducer.max.equals(max));
    }

    @Test(groups={"resolution"})
    @SpecAssertions(value={@SpecAssertion(section="5.2", id="ld"), @SpecAssertion(section="5.2.5", id="b")})
    public void testResolveByTypeWithNonBindingMembers() throws Exception {
        Set<Bean<Animal>> beans = this.getBeans(Animal.class, new Annotation[]{new ExpensiveLiteral(){

            @Override
            public int cost() {
                return 60;
            }

            @Override
            public boolean veryExpensive() {
                return true;
            }
        }, new AnnotationLiteral<Whitefish>(){}});
        assert (beans.size() == 2);
        HashSet classes = new HashSet();
        for (Bean<Animal> bean : beans) {
            classes.addAll(bean.getTypes());
        }
        assert (classes.contains(Halibut.class));
        assert (classes.contains(RoundWhitefish.class));
        assert (!classes.contains(Sole.class));
    }

    @Test(groups={"policy", "rewrite"})
    @SpecAssertion(section="5.1.4", id="i")
    public void testPolicyNotAvailableInNonDeploymentArchive() throws Exception {
        Set<Bean<Spider>> spiders = this.getBeans(Spider.class, new Annotation[0]);
        HashSet types = new HashSet();
        for (Bean<Spider> spider : spiders) {
            types.addAll(spider.getTypes());
        }
        assert (!types.contains(CrabSpider.class));
        assert (!types.contains(DaddyLongLegs.class));
        assert (this.getCurrentManager().getBeans("crabSpider").size() == 0);
    }

    @Test
    @SpecAssertion(section="2.2.2", id="a")
    public void testBeanTypesOnManagedBean() {
        assert (this.getBeans(Canary.class, new Annotation[0]).size() == 1);
        Bean<Canary> bean = this.getUniqueBean(Canary.class, new Annotation[0]);
        assert (this.getBeans(Bird.class, new Annotation[0]).isEmpty());
        assert (this.typeSetMatches(bean.getTypes(), new Type[]{Canary.class, Object.class}));
    }

    @Test
    @SpecAssertion(section="2.2.2", id="e")
    public void testGenericBeanTypesOnManagedBean() {
        assert (this.getBeans(AUSTRALIAN_FLIGHTLESS_BIRD, new Annotation[0]).size() == 1);
        assert (this.getBeans(Emu.class, new Annotation[0]).isEmpty());
        assert (this.getBeans(EUROPEAN_FLIGHTLESS_BIRD, new Annotation[0]).isEmpty());
        Bean<FlightlessBird<Australian>> bean = this.getUniqueBean(AUSTRALIAN_FLIGHTLESS_BIRD, new Annotation[0]);
        assert (this.typeSetMatches(bean.getTypes(), new Type[]{AUSTRALIAN_FLIGHTLESS_BIRD.getType(), Object.class}));
    }

    @Test
    @SpecAssertion(section="2.2.2", id="c")
    public void testBeanTypesOnProducerMethod() {
        assert (this.getBeans(Parrot.class, new Annotation[0]).size() == 1);
        assert (this.getBeans(Bird.class, new Annotation[0]).isEmpty());
        Bean<Parrot> bean = this.getUniqueBean(Parrot.class, new Annotation[0]);
        assert (this.typeSetMatches(bean.getTypes(), new Type[]{Parrot.class, Object.class}));
    }

    @Test
    @SpecAssertion(section="2.2.2", id="h")
    public void testGenericBeanTypesOnProducerField() {
        assert (this.getBeans(EUROPEAN_CAT, TAME).size() == 1);
        assert (this.getBeans(DomesticCat.class, TAME).isEmpty());
        Bean<Cat<European>> bean = this.getUniqueBean(EUROPEAN_CAT, TAME);
        assert (this.typeSetMatches(bean.getTypes(), new Type[]{EUROPEAN_CAT.getType(), Object.class}));
    }

    @Test
    @SpecAssertion(section="2.2.2", id="g")
    public void testGenericBeanTypesOnProducerMethod() {
        assert (this.getBeans(AFRICAN_CAT, WILD).size() == 1);
        assert (this.getBeans(Lion.class, WILD).isEmpty());
        Bean<Cat<African>> bean = this.getUniqueBean(AFRICAN_CAT, WILD);
        assert (this.typeSetMatches(bean.getTypes(), new Type[]{AFRICAN_CAT.getType(), Object.class}));
    }

    @Test
    @SpecAssertion(section="2.2.2", id="d")
    public void testBeanTypesOnProducerField() {
        assert (this.getBeans(Dove.class, new Annotation[0]).size() == 1);
        assert (this.getBeans(Bird.class, new Annotation[0]).isEmpty());
        Bean<Dove> bean = this.getUniqueBean(Dove.class, new Annotation[0]);
        assert (this.typeSetMatches(bean.getTypes(), new Type[]{Dove.class, Object.class}));
    }
}

