/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.lookup.typesafe.resolution.parameterized;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.util.TypeLiteral;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.parameterized.Dao;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.parameterized.InjectedBean;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.parameterized.IntegerHashMap;
import org.jboss.cdi.tck.tests.lookup.typesafe.resolution.parameterized.Result;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class AssignabilityOfRawAndParameterizedTypesTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(AssignabilityOfRawAndParameterizedTypesTest.class)).build();
    }

    @Test(groups={"resolution"})
    @SpecAssertions(value={@SpecAssertion(section="5.2", id="kb"), @SpecAssertion(section="2.2.1", id="f"), @SpecAssertion(section="2.2.1", id="g")})
    public void testAssignabilityToRawType() {
        Set<Bean<Dao>> beans = this.getBeans(Dao.class, new Annotation[0]);
        assert (this.getBeans(Dao.class, new Annotation[0]).size() == 4);
    }

    @Test(groups={"resolution"})
    @SpecAssertion(section="5.2.3", id="ba")
    public void testAssignabilityOfParameterizedTypeWithActualTypesToParameterizedTypeWithActualTypes() {
        assert (this.getBeans(new TypeLiteral<Map<Integer, Integer>>(){}, new Annotation[0]).size() == 2);
        assert (this.getBeans(new TypeLiteral<HashMap<Integer, Integer>>(){}, new Annotation[0]).iterator().next().getTypes().contains(IntegerHashMap.class));
    }

    @Test(groups={"resolution"})
    @SpecAssertions(value={@SpecAssertion(section="5.2.3", id="c")})
    public void testAssignabilityOfParameterizedTypeWithActualTypesToParameterizedTypeWithWildcards() {
        assert (this.getBeans(new TypeLiteral<HashMap<? extends Number, ? super Integer>>(){}, new Annotation[0]).size() == 1);
        assert (this.getBeans(new TypeLiteral<HashMap<? extends Number, ? super Integer>>(){}, new Annotation[0]).iterator().next().getTypes().contains(IntegerHashMap.class));
    }

    @Test(groups={"resolution"})
    @SpecAssertions(value={@SpecAssertion(section="5.2.2", id="b")})
    public void testAssignabilityOfParameterizedTypeWithActualTypesToParameterizedTypeWithWildcardsAtInjectionPoint() {
        assert (this.getInstanceByType(InjectedBean.class, new Annotation[0]).getMap() instanceof IntegerHashMap);
    }

    @Test(groups={"resolution"})
    @SpecAssertion(section="5.2.3", id="da")
    public void testAssignabilityOfParameterizedTypeWithTypeVariablesToParameterizedTypeWithWildcards() {
        Set<Bean<Result<? extends Throwable, ? super Exception>>> beans = this.getBeans(new TypeLiteral<Result<? extends Throwable, ? super Exception>>(){}, new Annotation[0]);
        assert (beans.size() == 1);
        assert (this.rawTypeSetMatches(beans.iterator().next().getTypes(), Result.class, Object.class));
    }

    @Test(groups={"resolution"})
    @SpecAssertion(section="5.2.3", id="db")
    public void testAssignabilityOfParameterizedTypeWithTypeVariablesToParameterizedTypeWithWildcards2() {
        Set<Bean<Result<? extends Exception, ? super Exception>>> beans = this.getBeans(new TypeLiteral<Result<? extends Exception, ? super Exception>>(){}, new Annotation[0]);
        assert (beans.size() == 1);
        assert (this.rawTypeSetMatches(beans.iterator().next().getTypes(), Result.class, Object.class));
    }

    @Test(groups={"resolution"})
    @SpecAssertion(section="5.2.3", id="e")
    public void testAssignabilityOfParameterizedTypeWithTypeVariablesToParameterizedTypeWithActualTypes() {
        Set<Bean<Result<Exception, Exception>>> beans = this.getBeans(new TypeLiteral<Result<Exception, Exception>>(){}, new Annotation[0]);
        assert (beans.size() == 1);
        assert (this.rawTypeSetMatches(beans.iterator().next().getTypes(), Result.class, Object.class));
    }

    @Test(groups={"resolution"})
    @SpecAssertion(section="5.2.3", id="f")
    public <T1 extends Exception, T2 extends Exception> void testAssignabilityOfParameterizedTypeWithTypeVariablesToParameterizedTypeTypeVariable() {
        Set beans = this.getBeans(new TypeLiteral<Result<T1, T2>>(){}, new Annotation[0]);
        assert (beans.size() == 1);
        assert (this.rawTypeSetMatches(beans.iterator().next().getTypes(), Result.class, Object.class));
    }
}

