/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.application.ejb;

import java.lang.annotation.Annotation;
import java.util.concurrent.Future;
import javax.ejb.EJB;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.Timer;
import org.jboss.cdi.tck.shrinkwrap.EnterpriseArchiveBuilder;
import org.jboss.cdi.tck.tests.context.application.ejb.FMS;
import org.jboss.cdi.tck.tests.context.application.ejb.FMSModelIII;
import org.jboss.cdi.tck.tests.context.application.ejb.SimpleApplicationBean;
import org.jboss.cdi.tck.tests.context.request.ejb.BarBean;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"javaee-full"})
@SpecVersion(spec="cdi", version="20091101")
public class ApplicationContextSharedTest
extends AbstractTest {
    @EJB
    BarBean bar;

    @Deployment
    public static EnterpriseArchive createTestArchive() {
        return (EnterpriseArchive)((EnterpriseArchiveBuilder)new EnterpriseArchiveBuilder().withTestClassPackage(ApplicationContextSharedTest.class)).build();
    }

    @Test(groups={"contexts"})
    @SpecAssertion(section="6.7.3", id="e")
    public void testApplicationContextShared() throws Exception {
        FMSModelIII.reset();
        FMS flightManagementSystem = this.getInstanceByType(FMS.class, new Annotation[0]);
        flightManagementSystem.climb();
        Timer timer = new Timer().setDelay(20000L).addStopCondition(new Timer.StopCondition(){

            @Override
            public boolean isSatisfied() {
                return FMSModelIII.isClimbed();
            }
        }).start();
        flightManagementSystem.descend();
        timer.addStopCondition(new Timer.StopCondition(){

            @Override
            public boolean isSatisfied() {
                return FMSModelIII.isDescended();
            }
        }, true).start();
        Assert.assertTrue((boolean)flightManagementSystem.isSameBean());
    }

    @Test(groups={"contexts"})
    @SpecAssertion(section="6.7.3", id="dc")
    public void testApplicationScopeActiveDuringCallToEjbTimeoutMethod() throws Exception {
        FMS flightManagementSystem = this.getInstanceByType(FMS.class, new Annotation[0]);
        flightManagementSystem.climb();
        new Timer().setDelay(20000L).addStopCondition(new Timer.StopCondition(){

            @Override
            public boolean isSatisfied() {
                return FMSModelIII.isClimbed();
            }
        }).start();
        Assert.assertTrue((boolean)flightManagementSystem.isApplicationScopeActive());
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER", groups={"contexts"})
    @SpecAssertions(value={@SpecAssertion(section="6.7.3", id="db")})
    public void testApplicationScopeActiveDuringAsyncCallToEjb(SimpleApplicationBean simpleApplicationBean) throws Exception {
        Future<Double> result = this.bar.compute();
        Double id = result.get();
        Assert.assertNotEquals((Object)id, (Object)-1.0);
        Assert.assertEquals((Object)id, (Object)simpleApplicationBean.getId());
    }
}

