/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.conversation;

import java.lang.annotation.Annotation;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.Conversation;
import javax.enterprise.context.ConversationScoped;
import javax.enterprise.inject.spi.BeanManager;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletResponse;
import org.jboss.cdi.tck.impl.OldSPIBridge;
import org.jboss.cdi.tck.tests.context.conversation.Cloud;

public class ConversationTestPhaseListener
implements PhaseListener {
    private static final long serialVersionUID = 1197355854770726526L;
    public static final String ACTIVE_BEFORE_APPLY_REQUEST_VALUES_HEADER_NAME = "org.jboss.cdi.tck.activeBeforeApplyRequestValues";
    private boolean activeBeforeApplyRequestValues;

    public void afterPhase(PhaseEvent event) {
    }

    public void beforePhase(PhaseEvent event) {
        BeanManager beanManager = (BeanManager)((ServletContext)event.getFacesContext().getExternalContext().getContext()).getAttribute(BeanManager.class.getName());
        if (event.getPhaseId().equals(PhaseId.APPLY_REQUEST_VALUES)) {
            try {
                beanManager.getContext(ConversationScoped.class);
                this.activeBeforeApplyRequestValues = true;
            }
            catch (ContextNotActiveException e) {
                this.activeBeforeApplyRequestValues = false;
            }
        }
        if (event.getPhaseId().equals(PhaseId.RENDER_RESPONSE)) {
            Conversation conversation = OldSPIBridge.getInstanceByType(beanManager, Conversation.class, new Annotation[0]);
            HttpServletResponse response = (HttpServletResponse)event.getFacesContext().getExternalContext().getResponse();
            response.addHeader("org.jboss.cdi.tck.cid", conversation.getId() == null ? " null" : conversation.getId());
            response.addHeader("org.jboss.cdi.tck.longRunning", String.valueOf(!conversation.isTransient()));
            response.addHeader(Cloud.RAINED_HEADER_NAME, new Boolean(OldSPIBridge.getInstanceByType(beanManager, Cloud.class, new Annotation[0]).isRained()).toString());
            response.addHeader(ACTIVE_BEFORE_APPLY_REQUEST_VALUES_HEADER_NAME, new Boolean(this.activeBeforeApplyRequestValues).toString());
        }
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }
}

