/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.conversation;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlSubmitInput;
import com.gargoylesoftware.htmlunit.html.HtmlTextInput;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.context.conversation.AbstractConversationTest;
import org.jboss.cdi.tck.tests.context.conversation.Cloud;
import org.jboss.cdi.tck.tests.context.conversation.ConversationStatusServlet;
import org.jboss.cdi.tck.tests.context.conversation.ConversationTestPhaseListener;
import org.jboss.cdi.tck.tests.context.conversation.OutermostFilter;
import org.jboss.cdi.tck.tests.context.conversation.Storm;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@Test(groups={"integration"})
@SpecVersion(spec="cdi", version="20091101")
public class LongRunningConversationPropagatedByFacesContextTest
extends AbstractConversationTest {
    private static final String STORM_STRENGTH = "12";
    private static final String REDIRECT_STORM_STRENGTH = "15";

    @Deployment(testable=false)
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassDefinition(LongRunningConversationPropagatedByFacesContextTest.class)).withClasses(Storm.class, ConversationTestPhaseListener.class, ConversationStatusServlet.class, Cloud.class, OutermostFilter.class)).withWebResource("storm.jsf", "storm.jspx")).withWebResource("thunder.jsf", "thunder.jspx")).withWebResource("lightening.jsf", "lightening.jspx")).withWebResource("faces-config.xml", "/WEB-INF/faces-config.xml")).withWebXml("web.xml")).build();
    }

    @Test(groups={"contexts"})
    @SpecAssertions(value={@SpecAssertion(section="6.7.4", id="l"), @SpecAssertion(section="2.4.1", id="ba")})
    public void testConversationPropagated() throws Exception {
        WebClient webClient = new WebClient();
        HtmlPage storm = (HtmlPage)webClient.getPage(this.getPath("storm.jsf"));
        HtmlSubmitInput beginConversationButton = this.getFirstMatchingElement(storm, HtmlSubmitInput.class, "beginConversationButton");
        storm = (HtmlPage)beginConversationButton.click();
        HtmlTextInput stormStrength = this.getFirstMatchingElement(storm, HtmlTextInput.class, "stormStrength");
        stormStrength.setValueAttribute(STORM_STRENGTH);
        String stormCid = this.getCid((Page)storm);
        HtmlSubmitInput thunderButton = this.getFirstMatchingElement(storm, HtmlSubmitInput.class, "thunderButton");
        HtmlPage thunder = (HtmlPage)thunderButton.click();
        assert (stormCid.equals(this.getCid((Page)thunder)));
        stormStrength = this.getFirstMatchingElement(thunder, HtmlTextInput.class, "stormStrength");
        assert (stormStrength.getValueAttribute().equals(STORM_STRENGTH));
    }

    @Test(groups={"contexts"})
    @SpecAssertion(section="6.7.4", id="m")
    public void testConversationPropagatedOverRedirect() throws Exception {
        WebClient webClient = new WebClient();
        HtmlPage storm = (HtmlPage)webClient.getPage(this.getPath("storm.jsf"));
        HtmlSubmitInput beginConversationButton = this.getFirstMatchingElement(storm, HtmlSubmitInput.class, "beginConversationButton");
        storm = (HtmlPage)beginConversationButton.click();
        HtmlTextInput stormStrength = this.getFirstMatchingElement(storm, HtmlTextInput.class, "stormStrength");
        stormStrength.setValueAttribute(REDIRECT_STORM_STRENGTH);
        String stormCid = this.getCid((Page)storm);
        HtmlSubmitInput lighteningButton = this.getFirstMatchingElement(storm, HtmlSubmitInput.class, "lighteningButton");
        HtmlPage lightening = (HtmlPage)lighteningButton.click();
        assert (lightening.getWebResponse().getRequestUrl().toString().contains("lightening.jsf"));
        assert (stormCid.equals(this.getCid((Page)lightening)));
        stormStrength = this.getFirstMatchingElement(lightening, HtmlTextInput.class, "stormStrength");
        assert (stormStrength.getValueAttribute().equals(REDIRECT_STORM_STRENGTH));
    }
}

