/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.jms;

import java.util.List;
import javax.inject.Inject;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.Timer;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.context.jms.AbstractMessageListener;
import org.jboss.cdi.tck.tests.context.jms.LogStore;
import org.jboss.cdi.tck.tests.context.jms.LoggerService;
import org.jboss.cdi.tck.tests.context.jms.QueueMessageDrivenBean;
import org.jboss.cdi.tck.tests.context.jms.SimpleMessageProducer;
import org.jboss.cdi.tck.tests.context.jms.TopicMessageDrivenBean;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"javaee-full", "jms"})
@SpecVersion(spec="cdi", version="20091101")
public class MessageDrivenBeanContextTest
extends AbstractTest {
    @Inject
    SimpleMessageProducer producer;
    @Inject
    LogStore store;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClass(MessageDrivenBeanContextTest.class)).withClasses(LoggerService.class, LogStore.class, SimpleMessageProducer.class, AbstractMessageListener.class, QueueMessageDrivenBean.class, TopicMessageDrivenBean.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="6.7.1", id="gd"), @SpecAssertion(section="6.7.1", id="hd"), @SpecAssertion(section="6.7.3", id="dd")})
    public void testRequestScopeActiveDuringMessageDelivery() throws Exception {
        AbstractMessageListener.resetProcessedMessages();
        this.producer.sendQueueMessage();
        this.producer.sendTopicMessage();
        new Timer().setDelay(2000L).addStopCondition(new Timer.StopCondition(){

            @Override
            public boolean isSatisfied() {
                return AbstractMessageListener.processedMessages.get() >= 2;
            }
        }).start();
        List<LogStore.LogMessage> logMessages = this.store.getLogMessages();
        Assert.assertEquals((int)logMessages.size(), (int)2);
        LogStore.LogMessage msg1 = logMessages.get(0);
        Assert.assertEquals((String)msg1.getText(), (String)SimpleMessageProducer.class.getName());
        LogStore.LogMessage msg2 = logMessages.get(1);
        Assert.assertEquals((String)msg2.getText(), (String)SimpleMessageProducer.class.getName());
        Assert.assertFalse((boolean)msg1.getServiceId().equals(msg2.getServiceId()));
    }
}

