/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.request;

import java.io.IOException;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import org.jboss.cdi.tck.SimpleLogger;
import org.jboss.cdi.tck.tests.context.request.RequestContextGuard;
import org.jboss.cdi.tck.tests.context.request.SimpleRequestBean;

@WebFilter(filterName="DestroyTestFilter", urlPatterns={"/introspectRequest"})
public class IntrospectTestFilter
implements Filter {
    private static final SimpleLogger logger = new SimpleLogger(IntrospectTestFilter.class);
    @Inject
    private BeanManager beanManager;
    @Inject
    private SimpleRequestBean simpleBean;
    @Inject
    private RequestContextGuard guard;

    public void destroy() {
        this.beanManager = null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        logger.log("Do filter...", new Object[0]);
        this.checkRequestContextActive();
        chain.doFilter(request, response);
        this.checkRequestContextActive();
        String mode = request.getParameter("guard");
        if (mode != null && mode.equals("collect")) {
            this.guard.setFilterCheckpoint(System.currentTimeMillis());
        }
    }

    private void checkRequestContextActive() throws ServletException {
        if (this.beanManager == null || !this.beanManager.getContext(RequestScoped.class).isActive() || this.simpleBean == null) {
            throw new ServletException("Request context is not active");
        }
        this.simpleBean.getId();
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }
}

