/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.request;

import java.util.ArrayList;
import java.util.Collections;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Destroyed;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.event.Observes;
import javax.servlet.ServletRequestEvent;

@ApplicationScoped
public class RequestContextGuard {
    private long servletRequestListenerCheckpoint = 0L;
    private long filterCheckpoint = 0L;
    private long servletCheckpoint = 0L;
    private long requestContextDestroyedCheckpoint = 0L;

    public void observeRequestDestroyed(@Observes @Destroyed(value=RequestScoped.class) ServletRequestEvent event) {
        this.requestContextDestroyedCheckpoint = System.currentTimeMillis();
    }

    public long getServletRequestListenerCheckpoint() {
        return this.servletRequestListenerCheckpoint;
    }

    public void setServletRequestListenerCheckpoint(long servletRequestListenerCheckpoint) {
        this.servletRequestListenerCheckpoint = servletRequestListenerCheckpoint;
    }

    public long getFilterCheckpoint() {
        return this.filterCheckpoint;
    }

    public void setFilterCheckpoint(long filterCheckpoint) {
        this.filterCheckpoint = filterCheckpoint;
    }

    public long getServletCheckpoint() {
        return this.servletCheckpoint;
    }

    public void setServletCheckpoint(long servletCheckpoint) {
        this.servletCheckpoint = servletCheckpoint;
    }

    public long getRequestContextDestroyedCheckpoint() {
        return this.requestContextDestroyedCheckpoint;
    }

    public void setRequestContextDestroyedAt(long requestContextDestroyedAt) {
        this.requestContextDestroyedCheckpoint = requestContextDestroyedAt;
    }

    public boolean isCheckpointSequenceOk() {
        if (this.servletCheckpoint <= 0L || this.filterCheckpoint <= 0L || this.servletRequestListenerCheckpoint <= 0L || this.requestContextDestroyedCheckpoint <= 0L) {
            return false;
        }
        ArrayList<Long> sequence = new ArrayList<Long>();
        sequence.add(this.servletCheckpoint);
        sequence.add(this.filterCheckpoint);
        sequence.add(this.servletRequestListenerCheckpoint);
        sequence.add(this.requestContextDestroyedCheckpoint);
        ArrayList<Long> ascSequence = new ArrayList<Long>();
        ascSequence.addAll(sequence);
        Collections.sort(ascSequence);
        return ((Object)sequence).equals(ascSequence);
    }
}

