/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.request.ejb;

import java.lang.annotation.Annotation;
import java.util.concurrent.Future;
import javax.ejb.EJB;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.OperateOnDeployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.Timer;
import org.jboss.cdi.tck.shrinkwrap.EnterpriseArchiveBuilder;
import org.jboss.cdi.tck.tests.context.request.ejb.BarBean;
import org.jboss.cdi.tck.tests.context.request.ejb.FMS;
import org.jboss.cdi.tck.tests.context.request.ejb.FMSModelIII;
import org.jboss.cdi.tck.tests.context.request.ejb.FooBean;
import org.jboss.cdi.tck.tests.context.request.ejb.FooRemote;
import org.jboss.cdi.tck.tests.context.request.ejb.FooRequestBean;
import org.jboss.cdi.tck.tests.context.request.ejb.SimpleRequestBean;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@Test(groups={"javaee-full"})
@SpecVersion(spec="cdi", version="20091101")
public class EJBRequestContextTest
extends AbstractTest {
    @EJB(lookup="java:global/test-ejb/test-ejb/FooBean!org.jboss.cdi.tck.tests.context.request.ejb.FooRemote")
    FooRemote foo;
    @EJB
    BarBean bar;

    @Deployment(name="TEST", order=1)
    public static EnterpriseArchive createTestArchive() {
        return (EnterpriseArchive)((EnterpriseArchiveBuilder)((EnterpriseArchiveBuilder)new EnterpriseArchiveBuilder().withTestClass(EJBRequestContextTest.class)).withClasses(FMS.class, FMSModelIII.class, BarBean.class, SimpleRequestBean.class, FooRemote.class)).build();
    }

    @Deployment(name="REMOTE_EJB", order=2)
    public static EnterpriseArchive createEjbArchive() {
        return (EnterpriseArchive)((EnterpriseArchiveBuilder)((EnterpriseArchiveBuilder)((EnterpriseArchiveBuilder)new EnterpriseArchiveBuilder().notTestArchive()).noDefaultWebModule().withName("test-ejb.ear")).withEjbModuleName("test-ejb.jar").withClasses(FooBean.class, FooRemote.class, FooRequestBean.class)).build();
    }

    @OperateOnDeployment(value="TEST")
    @Test(groups={"contexts"})
    @SpecAssertion(section="6.7.1", id="gc")
    public void testRequestScopeActiveDuringCallToEjbTimeoutMethod() throws Exception {
        FMSModelIII.reset();
        FMS flightManagementSystem = this.getInstanceByType(FMS.class, new Annotation[0]);
        flightManagementSystem.climb();
        new Timer().setDelay(20000L).addStopCondition(new Timer.StopCondition(){

            @Override
            public boolean isSatisfied() {
                return FMSModelIII.isClimbed();
            }
        }).start();
        assert (flightManagementSystem.isRequestScopeActive());
    }

    @OperateOnDeployment(value="TEST")
    @Test(groups={"contexts"})
    @SpecAssertion(section="6.7.1", id="hc")
    public void testRequestScopeDestroyedAfterCallToEjbTimeoutMethod() throws Exception {
        FMSModelIII.reset();
        SimpleRequestBean.reset();
        FMS flightManagementSystem = this.getInstanceByType(FMS.class, new Annotation[0]);
        flightManagementSystem.climb();
        Timer timer = new Timer().setDelay(20000L).addStopCondition(new Timer.StopCondition(){

            @Override
            public boolean isSatisfied() {
                return FMSModelIII.isClimbed();
            }
        }).start();
        flightManagementSystem.descend();
        timer.addStopCondition(new Timer.StopCondition(){

            @Override
            public boolean isSatisfied() {
                return FMSModelIII.isDescended();
            }
        }, true).start();
        assert (!flightManagementSystem.isSameBean());
        assert (SimpleRequestBean.isBeanDestroyed());
    }

    @OperateOnDeployment(value="TEST")
    @Test(groups={"contexts"})
    @SpecAssertions(value={@SpecAssertion(section="6.7.1", id="ga"), @SpecAssertion(section="6.7.1", id="ha")})
    public void testRequestScopeActiveDuringRemoteCallToEjb() throws Exception {
        assert (this.foo.ping() != null);
        assert (this.foo.wasRequestBeanInPreviousCallDestroyed());
    }

    @OperateOnDeployment(value="TEST")
    @Test(groups={"contexts"})
    @SpecAssertions(value={@SpecAssertion(section="6.7.1", id="gb"), @SpecAssertion(section="6.7.1", id="hb")})
    public void testRequestScopeActiveDuringAsyncCallToEjb() throws Exception {
        SimpleRequestBean simpleRequestBean = this.getInstanceByType(SimpleRequestBean.class, new Annotation[0]);
        SimpleRequestBean.reset();
        Future<Double> result = this.bar.compute();
        Double id = result.get();
        assert (id != -1.0);
        assert (id.doubleValue() != simpleRequestBean.getId());
        assert (SimpleRequestBean.isBeanDestroyed());
    }
}

