/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.request.ejb;

import java.io.Serializable;
import javax.annotation.Resource;
import javax.ejb.Stateless;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import org.jboss.cdi.tck.tests.context.request.ejb.FMS;
import org.jboss.cdi.tck.tests.context.request.ejb.SimpleRequestBean;

@Stateless
public class FMSModelIII
implements FMS {
    private static final long serialVersionUID = 1L;
    private static final String CLIMB_COMMAND = "ClimbCommand";
    private static final String DESCEND_COMMAND = "DescendCommand";
    @Resource
    private TimerService timerService;
    @Inject
    private BeanManager beanManager;
    @Inject
    Instance<SimpleRequestBean> simpleRequestBean;
    private static volatile boolean requestScopeActive = false;
    private static volatile double beanId = 0.0;
    private static volatile boolean sameBean = false;
    private static volatile boolean climbed;
    private static volatile boolean descended;

    @Override
    public void climb() {
        this.timerService.createTimer(200L, (Serializable)((Object)CLIMB_COMMAND));
    }

    @Override
    public void descend() {
        this.timerService.createTimer(100L, (Serializable)((Object)DESCEND_COMMAND));
    }

    @Timeout
    public void timeout(Timer timer) {
        if (this.beanManager.getContext(RequestScoped.class).isActive()) {
            requestScopeActive = true;
            if (beanId > 0.0) {
                if (beanId == ((SimpleRequestBean)this.simpleRequestBean.get()).getId()) {
                    sameBean = true;
                }
            } else {
                beanId = ((SimpleRequestBean)this.simpleRequestBean.get()).getId();
            }
        }
        if (timer.getInfo().equals(CLIMB_COMMAND)) {
            climbed = true;
        }
        if (timer.getInfo().equals(DESCEND_COMMAND)) {
            descended = true;
        }
    }

    @Override
    public boolean isRequestScopeActive() {
        return requestScopeActive;
    }

    public static void reset() {
        beanId = 0.0;
        climbed = false;
        descended = false;
        requestScopeActive = false;
        sameBean = false;
    }

    @Override
    public boolean isSameBean() {
        return sameBean;
    }

    public static boolean isClimbed() {
        return climbed;
    }

    public static boolean isDescended() {
        return descended;
    }
}

