/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.session;

import com.gargoylesoftware.htmlunit.TextPage;
import com.gargoylesoftware.htmlunit.WebClient;
import java.net.URL;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.Timer;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@Test(groups={"integration"})
@SpecVersion(spec="cdi", version="20091101")
public class SessionContextTest
extends AbstractTest {
    private static final long DEFAULT_SLEEP_INTERVAL = 3000L;
    @ArquillianResource
    private URL contextPath;

    @Deployment(testable=false)
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(SessionContextTest.class)).withWebResource("SimplePage.html", "SimplePage.html")).withWebXml("web.xml")).build();
    }

    @Test(groups={"contexts", "servlet"})
    @SpecAssertion(section="6.7.2", id="aa")
    public void testSessionScopeActiveDuringServiceMethod() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        webClient.getPage(this.contextPath + "serviceMethodTest");
    }

    @Test(groups={"contexts", "servlet"})
    @SpecAssertion(section="6.7.2", id="ab")
    public void testSessionScopeActiveDuringDoFilterMethod() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        webClient.getPage(this.contextPath + "SimplePage.html");
    }

    @Test(groups={"contexts", "servlet"})
    @SpecAssertion(section="6.7.2", id="b")
    public void testSessionContextSharedBetweenServletRequestsInSameHttpSession() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        TextPage firstRequestResult = (TextPage)webClient.getPage(this.contextPath + "IntrospectSession");
        assert (firstRequestResult.getContent() != null);
        assert (Long.parseLong(firstRequestResult.getContent()) != 0L);
        TextPage secondRequestResult = (TextPage)webClient.getPage(this.contextPath + "IntrospectSession");
        assert (secondRequestResult.getContent() != null);
        assert (Long.parseLong(secondRequestResult.getContent()) == Long.parseLong(firstRequestResult.getContent()));
    }

    @Test(groups={"contexts", "servlet"})
    @SpecAssertion(section="6.7.2", id="ca")
    public void testSessionContextDestroyedWhenHttpSessionInvalidated() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        TextPage firstRequestResult = (TextPage)webClient.getPage(this.contextPath + "IntrospectSession");
        assert (firstRequestResult.getContent() != null);
        assert (Long.parseLong(firstRequestResult.getContent()) != 0L);
        webClient.getPage(this.contextPath + "InvalidateSession");
        TextPage secondRequestResult = (TextPage)webClient.getPage(this.contextPath + "IntrospectSession");
        assert (secondRequestResult.getContent() != null);
        assert (Long.parseLong(secondRequestResult.getContent()) != Long.parseLong(firstRequestResult.getContent()));
        TextPage beanDestructionResult = (TextPage)webClient.getPage(this.contextPath + "InvalidateSession?isBeanDestroyed");
        assert (Boolean.parseBoolean(beanDestructionResult.getContent()));
    }

    @Test(groups={"contexts", "servlet"})
    @SpecAssertion(section="6.7.2", id="cb")
    public void testSessionContextDestroyedWhenHttpSessionTimesOut() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        TextPage firstRequestResult = (TextPage)webClient.getPage(this.contextPath + "IntrospectSession");
        assert (firstRequestResult.getContent() != null);
        assert (Long.parseLong(firstRequestResult.getContent()) != 0L);
        webClient.getPage(this.contextPath + "InvalidateSession?timeout=1");
        Timer.startNew(3000L);
        TextPage secondRequestResult = (TextPage)webClient.getPage(this.contextPath + "IntrospectSession");
        assert (secondRequestResult.getContent() != null);
        assert (Long.parseLong(secondRequestResult.getContent()) != Long.parseLong(firstRequestResult.getContent()));
        TextPage beanDestructionResult = (TextPage)webClient.getPage(this.contextPath + "InvalidateSession?isBeanDestroyed");
        assert (Boolean.parseBoolean(beanDestructionResult.getContent()));
    }
}

