/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.deployment.packaging.ear.modules;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Extension;
import javax.inject.Inject;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.EnterpriseArchiveBuilder;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.deployment.packaging.ear.modules.AlternativeBar;
import org.jboss.cdi.tck.tests.deployment.packaging.ear.modules.Bar;
import org.jboss.cdi.tck.tests.deployment.packaging.ear.modules.BarInspector;
import org.jboss.cdi.tck.tests.deployment.packaging.ear.modules.Baz;
import org.jboss.cdi.tck.tests.deployment.packaging.ear.modules.Business;
import org.jboss.cdi.tck.tests.deployment.packaging.ear.modules.BusinessOperationEvent;
import org.jboss.cdi.tck.tests.deployment.packaging.ear.modules.BusinessOperationEventInspector;
import org.jboss.cdi.tck.tests.deployment.packaging.ear.modules.BusinessOperationObservedEvent;
import org.jboss.cdi.tck.tests.deployment.packaging.ear.modules.ContainerEventsObserver;
import org.jboss.cdi.tck.tests.deployment.packaging.ear.modules.Foo;
import org.jboss.cdi.tck.tests.deployment.packaging.ear.modules.LegacyService;
import org.jboss.cdi.tck.tests.deployment.packaging.ear.modules.LegacyServiceProducer;
import org.jboss.cdi.tck.tests.deployment.packaging.ear.modules.LoggingDecorator;
import org.jboss.cdi.tck.tests.deployment.packaging.ear.modules.NonEnterprise;
import org.jboss.cdi.tck.tests.deployment.packaging.ear.modules.Qux;
import org.jboss.cdi.tck.tests.deployment.packaging.ear.modules.Secured;
import org.jboss.cdi.tck.tests.deployment.packaging.ear.modules.SecurityInterceptor;
import org.jboss.cdi.tck.tests.deployment.packaging.ear.modules.Util;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.beans10.BeansDescriptor;
import org.jboss.shrinkwrap.descriptor.api.spec.se.manifest.ManifestDescriptor;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"javaee-full"})
public class EnterpriseArchiveModulesTest
extends AbstractTest {
    @Inject
    private Business foo;
    @Inject
    private BusinessOperationEventInspector inspector;
    @Inject
    private BarInspector barInspector;
    @NonEnterprise
    @Inject
    private Business baz;

    @Deployment
    public static EnterpriseArchive createTestArchive() {
        EnterpriseArchive enterpriseArchive = (EnterpriseArchive)((EnterpriseArchiveBuilder)((EnterpriseArchiveBuilder)((EnterpriseArchiveBuilder)((EnterpriseArchiveBuilder)new EnterpriseArchiveBuilder().withTestClassDefinition(EnterpriseArchiveModulesTest.class)).withClasses(Foo.class, BusinessOperationEventInspector.class)).withBeanLibrary((BeansDescriptor)((BeansDescriptor)Descriptors.create(BeansDescriptor.class)).createInterceptors().clazz(new String[]{SecurityInterceptor.class.getName()}).up(), Bar.class, AlternativeBar.class, Util.class, Business.class, BusinessOperationEvent.class, BusinessOperationObservedEvent.class, NonEnterprise.class, Secured.class, SecurityInterceptor.class, LoggingDecorator.class)).withLibrary(LegacyService.class)).noDefaultWebModule().build();
        JavaArchive barArchive = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"bar.jar")).addClasses(new Class[]{BarInspector.class, ContainerEventsObserver.class, LegacyServiceProducer.class})).addAsServiceProvider(Extension.class, new Class[]{ContainerEventsObserver.class})).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        enterpriseArchive.addAsModule((Archive)barArchive);
        WebArchive bazArchive = (WebArchive)((WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().notTestArchive()).withClasses(Baz.class, EnterpriseArchiveModulesTest.class)).withBeansXml((BeansDescriptor)((BeansDescriptor)((BeansDescriptor)Descriptors.create(BeansDescriptor.class)).createDecorators().clazz(new String[]{LoggingDecorator.class.getName()}).up()).createAlternatives().clazz(new String[]{AlternativeBar.class.getName()}).up())).withBeanLibrary(Qux.class)).build()).setManifest((Asset)new StringAsset(((ManifestDescriptor)((ManifestDescriptor)((ManifestDescriptor)Descriptors.create(ManifestDescriptor.class)).addToClassPath("test-ejb.jar")).addToClassPath("bar.jar")).exportAsString()));
        enterpriseArchive.addAsModule((Archive)bazArchive);
        return enterpriseArchive;
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="11.5", id="bb")})
    public void testExtensionAndContainerEvents() throws Exception {
        Assert.assertTrue((boolean)ContainerEventsObserver.allEventsOk());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="12.1", id="bba"), @SpecAssertion(section="12.1", id="bbb"), @SpecAssertion(section="12.1", id="bbc"), @SpecAssertion(section="12.1", id="bbe")})
    public void testVisibilityAndInterceptorEnablement() throws Exception {
        SecurityInterceptor.reset();
        this.inspector.reset();
        this.foo.businessOperation1();
        this.foo.businessOperation2();
        Assert.assertEquals((int)this.inspector.getBusinessOperationObservations(), (int)2);
        Assert.assertEquals((int)SecurityInterceptor.getNumberOfInterceptions(), (int)1);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="8.3", id="aa"), @SpecAssertion(section="8.2", id="a")})
    public void testDecoratorEnablement() throws Exception {
        LoggingDecorator.reset();
        this.baz.businessOperation1();
        this.foo.businessOperation1();
        Assert.assertEquals((int)LoggingDecorator.getNumberOfDecorationsPerformed(), (int)1);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="3.3", id="aa"), @SpecAssertion(section="3.3", id="c"), @SpecAssertion(section="10.2", id="i")})
    public void testProducerAndEventDuringDisposal() throws Exception {
        Bean<LegacyService> bean = this.getUniqueBean(LegacyService.class, new Annotation[0]);
        CreationalContext ctx = this.getCurrentManager().createCreationalContext(bean);
        LegacyService instance = (LegacyService)bean.create(ctx);
        bean.destroy((Object)instance, ctx);
        Assert.assertTrue((boolean)LegacyService.disposalObserved);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.1.1", id="c")})
    public void testAlternatives() throws Exception {
        Set beans = this.getCurrentManager().getBeans(AlternativeBar.class, new Annotation[0]);
        Assert.assertEquals((int)beans.size(), (int)1);
        Assert.assertEquals((Object)((Bean)beans.iterator().next()).getBeanClass(), AlternativeBar.class);
        Assert.assertFalse((boolean)this.barInspector.getBar().isAlternative());
    }
}

