/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.event;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import javax.enterprise.context.spi.Context;
import javax.enterprise.event.TransactionPhase;
import javax.enterprise.inject.spi.ObserverMethod;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.event.BullTerrier;
import org.jboss.cdi.tck.tests.event.Delivery;
import org.jboss.cdi.tck.tests.event.DisobedientDog;
import org.jboss.cdi.tck.tests.event.Egg;
import org.jboss.cdi.tck.tests.event.FarmShop;
import org.jboss.cdi.tck.tests.event.Farmer;
import org.jboss.cdi.tck.tests.event.IndirectStockWatcher;
import org.jboss.cdi.tck.tests.event.IntermediateStockWatcher;
import org.jboss.cdi.tck.tests.event.LargeDog;
import org.jboss.cdi.tck.tests.event.LazyFarmer;
import org.jboss.cdi.tck.tests.event.MultiBindingEvent;
import org.jboss.cdi.tck.tests.event.RoleBinding;
import org.jboss.cdi.tck.tests.event.Shop;
import org.jboss.cdi.tck.tests.event.ShowDog;
import org.jboss.cdi.tck.tests.event.SmallDog;
import org.jboss.cdi.tck.tests.event.StaticObserver;
import org.jboss.cdi.tck.tests.event.StockPrice;
import org.jboss.cdi.tck.tests.event.StockWatcher;
import org.jboss.cdi.tck.tests.event.TameAnnotationLiteral;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@Test(groups={"integration"})
@SpecVersion(spec="cdi", version="20091101")
public class EventTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(EventTest.class)).withBeansXml("beans.xml")).build();
    }

    @Test(groups={"events"})
    @SpecAssertions(value={@SpecAssertion(section="10.4.2", id="i"), @SpecAssertion(section="5.5.6", id="c"), @SpecAssertion(section="2.3.5", id="ca"), @SpecAssertion(section="3.11", id="a")})
    public void testObserverMethodReceivesInjectionsOnNonObservesParameters() {
        this.getCurrentManager().fireEvent((Object)"validate injected parameters", new Annotation[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"events"})
    @SpecAssertions(value={@SpecAssertion(section="10.4", id="c"), @SpecAssertion(section="5.5.6", id="a")})
    public void testStaticObserverMethodInvoked() {
        Context requestContext = this.getCurrentConfiguration().getContexts().getRequestContext();
        try {
            this.getCurrentConfiguration().getContexts().setInactive(requestContext);
            StaticObserver.reset();
            this.getCurrentManager().fireEvent((Object)new Delivery(), new Annotation[0]);
            assert (StaticObserver.isDeliveryReceived());
            StaticObserver.reset();
        }
        finally {
            this.getCurrentConfiguration().getContexts().setActive(requestContext);
        }
    }

    @Test(groups={"events"})
    @SpecAssertions(value={@SpecAssertion(section="4.3", id="cc"), @SpecAssertion(section="5.5.6", id="baa")})
    public void testObserverCalledOnMostSpecializedInstance() {
        Shop.observers.clear();
        this.getCurrentManager().fireEvent((Object)new Delivery(), new Annotation[0]);
        assert (Shop.observers.size() == 1);
        assert (Shop.observers.iterator().next().equals(FarmShop.class.getName()));
    }

    @Test(groups={"events"}, expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="11.3.11", id="c")
    public <T> void testEventObjectContainsTypeVariablesWhenResolvingFails() {
        this.eventObjectContainsTypeVariables(new ArrayList());
    }

    private <E> void eventObjectContainsTypeVariables(ArrayList<E> eventToFire) {
        this.getCurrentManager().resolveObserverMethods(eventToFire, new Annotation[0]);
    }

    @Test(groups={"events"})
    @SpecAssertions(value={@SpecAssertion(section="10.2.3", id="b"), @SpecAssertion(section="10.2.3", id="c")})
    public void testObserverMethodNotifiedWhenBindingsMatch() {
        this.getCurrentManager().fireEvent((Object)new MultiBindingEvent(), new Annotation[]{new RoleBinding("Admin"), new TameAnnotationLiteral()});
        assert (BullTerrier.isMultiBindingEventObserved());
        assert (BullTerrier.isSingleBindingEventObserved());
    }

    @Test(groups={"events", "inheritance"})
    @SpecAssertion(section="4.2", id="dc")
    public void testNonStaticObserverMethodInherited() {
        Egg egg = new Egg();
        this.getCurrentManager().fireEvent((Object)egg, new Annotation[0]);
        assert (this.typeSetMatches(egg.getClassesVisited(), new Type[]{Farmer.class, LazyFarmer.class}));
    }

    @Test(groups={"events", "inheritance"})
    @SpecAssertions(value={@SpecAssertion(section="4.2", id="di"), @SpecAssertion(section="11.1.3", id="f")})
    public void testNonStaticObserverMethodIndirectlyInherited() {
        StockPrice price = new StockPrice();
        this.getCurrentManager().fireEvent((Object)price, new Annotation[0]);
        assert (this.typeSetMatches(price.getClassesVisited(), new Type[]{StockWatcher.class, IntermediateStockWatcher.class, IndirectStockWatcher.class}));
    }

    @Test(groups={"events"})
    @SpecAssertion(section="11.1.3", id="e")
    public void testGetTransactionPhaseOnObserverMethod() {
        assert (((ObserverMethod)this.getCurrentManager().resolveObserverMethods((Object)new StockPrice(), new Annotation[0]).iterator().next()).getTransactionPhase().equals((Object)TransactionPhase.IN_PROGRESS));
        assert (((ObserverMethod)this.getCurrentManager().resolveObserverMethods((Object)new DisobedientDog(), new Annotation[0]).iterator().next()).getTransactionPhase().equals((Object)TransactionPhase.BEFORE_COMPLETION));
        assert (((ObserverMethod)this.getCurrentManager().resolveObserverMethods((Object)new ShowDog(), new Annotation[0]).iterator().next()).getTransactionPhase().equals((Object)TransactionPhase.AFTER_COMPLETION));
        assert (((ObserverMethod)this.getCurrentManager().resolveObserverMethods((Object)new SmallDog(), new Annotation[0]).iterator().next()).getTransactionPhase().equals((Object)TransactionPhase.AFTER_FAILURE));
        assert (((ObserverMethod)this.getCurrentManager().resolveObserverMethods((Object)new LargeDog(), new Annotation[0]).iterator().next()).getTransactionPhase().equals((Object)TransactionPhase.AFTER_SUCCESS));
    }

    @Test(groups={"events"})
    @SpecAssertion(section="11.1.3", id="ga")
    public void testInstanceOfBeanForEveryEnabledObserverMethod() {
        assert (!this.getCurrentManager().resolveObserverMethods((Object)new StockPrice(), new Annotation[0]).isEmpty());
        assert (!this.getCurrentManager().resolveObserverMethods((Object)new DisobedientDog(), new Annotation[0]).isEmpty());
        assert (!this.getCurrentManager().resolveObserverMethods((Object)new ShowDog(), new Annotation[0]).isEmpty());
        assert (!this.getCurrentManager().resolveObserverMethods((Object)new SmallDog(), new Annotation[0]).isEmpty());
        assert (!this.getCurrentManager().resolveObserverMethods((Object)new LargeDog(), new Annotation[0]).isEmpty());
    }
}

