/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.event.observer.enterprise;

import java.lang.annotation.Annotation;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.EnterpriseArchiveBuilder;
import org.jboss.cdi.tck.tests.event.observer.enterprise.Egg;
import org.jboss.cdi.tck.tests.event.observer.enterprise.Farmer;
import org.jboss.cdi.tck.tests.event.observer.enterprise.IndirectStockWatcher;
import org.jboss.cdi.tck.tests.event.observer.enterprise.IntermediateStockWatcher;
import org.jboss.cdi.tck.tests.event.observer.enterprise.LazyFarmer;
import org.jboss.cdi.tck.tests.event.observer.enterprise.StockPrice;
import org.jboss.cdi.tck.tests.event.observer.enterprise.StockWatcher;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@Test(groups={"javaee-full"})
@SpecVersion(spec="cdi", version="20091101")
public class EnterpriseEventInheritenceTest
extends AbstractTest {
    @Deployment
    public static EnterpriseArchive createTestArchive() {
        return (EnterpriseArchive)((EnterpriseArchiveBuilder)new EnterpriseArchiveBuilder().withTestClassPackage(EnterpriseEventInheritenceTest.class)).build();
    }

    @Test(groups={"events", "inheritance"})
    @SpecAssertion(section="4.2", id="df")
    public void testNonStaticObserverMethodInherited() throws Exception {
        Egg egg = new Egg();
        this.getCurrentManager().fireEvent((Object)egg, new Annotation[0]);
        assert (egg.getVisited().size() == 2);
        assert (egg.getVisited().contains(Farmer.class.getSimpleName()));
        assert (egg.getVisited().contains(LazyFarmer.class.getSimpleName()));
    }

    @Test(groups={"events", "inheritance"})
    @SpecAssertion(section="4.2", id="dl")
    public void testNonStaticObserverMethodIndirectlyInherited() throws Exception {
        StockPrice stockPrice = new StockPrice();
        this.getCurrentManager().fireEvent((Object)stockPrice, new Annotation[0]);
        assert (stockPrice.getVisited().size() == 3);
        assert (stockPrice.getVisited().contains(StockWatcher.class.getSimpleName()));
        assert (stockPrice.getVisited().contains(IntermediateStockWatcher.class.getSimpleName()));
        assert (stockPrice.getVisited().contains(IndirectStockWatcher.class.getSimpleName()));
    }
}

