/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.extensions.bean.bytype;

import java.lang.annotation.Annotation;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Set;
import javax.enterprise.inject.spi.Bean;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.literals.DefaultLiteral;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.extensions.bean.bytype.NonBindingTypeLiteral;
import org.jboss.cdi.tck.tests.extensions.bean.bytype.SimpleBean;
import org.jboss.cdi.tck.tests.extensions.bean.bytype.TameLiteral;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class BeanByTypeTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(BeanByTypeTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="11.3.5", id="aa"), @SpecAssertion(section="11.3.5", id="b")})
    public void testGetBeans() {
        Set beans = this.getCurrentManager().getBeans(SimpleBean.class, new Annotation[0]);
        assert (beans.size() == 1);
        assert (((Bean)beans.iterator().next()).getBeanClass().equals(SimpleBean.class));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="11.3.5", id="c")})
    public void testNoBindingImpliesCurrent() {
        Set beans = this.getCurrentManager().getBeans(SimpleBean.class, new Annotation[0]);
        assert (beans.size() == 1);
        assert (((Bean)beans.iterator().next()).getQualifiers().contains((Object)new DefaultLiteral()));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertions(value={@SpecAssertion(section="11.3.5", id="da")})
    public void testTypeVariable() {
        TypeVariable<GenericDeclaration> t = new TypeVariable<GenericDeclaration>(){

            @Override
            public Type[] getBounds() {
                return new Type[0];
            }

            @Override
            public GenericDeclaration getGenericDeclaration() {
                return null;
            }

            @Override
            public String getName() {
                return "";
            }
        };
        this.getCurrentManager().getBeans((Type)t, new Annotation[0]);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertions(value={@SpecAssertion(section="11.3.5", id="e")})
    public void testSameBindingTwice() {
        this.getCurrentManager().getBeans(SimpleBean.class, new Annotation[]{new TameLiteral(), new TameLiteral()});
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertions(value={@SpecAssertion(section="11.3.5", id="f")})
    public void testNonBindingType() {
        this.getCurrentManager().getBeans(SimpleBean.class, new Annotation[]{new NonBindingTypeLiteral()});
    }
}

