/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.extensions.container.event.jms;

import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import javax.inject.Inject;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.extensions.container.event.jms.ProcessInjectionTargetObserver;
import org.jboss.cdi.tck.tests.extensions.container.event.jms.QueueMessageDrivenBean;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"javaee-full", "jms"})
@SpecVersion(spec="cdi", version="20091101")
public class ContainerEventTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(ContainerEventTest.class)).withExtension(ProcessInjectionTargetObserver.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="11.5.8", id="aaba"), @SpecAssertion(section="11.5.8", id="abba")})
    public void testProcessInjectionTargetEventFiredForMessageDrivenBean() {
        ProcessInjectionTarget<QueueMessageDrivenBean> event = ProcessInjectionTargetObserver.getMdbEvent();
        Assert.assertNotNull(event);
        AnnotatedType annotatedType = event.getAnnotatedType();
        Assert.assertEquals((Object)annotatedType.getBaseType(), QueueMessageDrivenBean.class);
        Assert.assertEquals((int)annotatedType.getMethods().size(), (int)2);
        for (AnnotatedMethod method : annotatedType.getMethods()) {
            Assert.assertTrue((method.isAnnotationPresent(Inject.class) || method.isAnnotationPresent(Override.class) ? 1 : 0) != 0);
        }
        Assert.assertEquals((int)annotatedType.getFields().size(), (int)2);
        for (AnnotatedField field : annotatedType.getFields()) {
            Assert.assertTrue((field.isAnnotationPresent(Inject.class) || field.isAnnotationPresent(SuppressWarnings.class) ? 1 : 0) != 0);
        }
    }
}

